/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.management.DefaultManagementAgent;
import org.apache.camel.management.JmxManagementLifecycleStrategy;
import org.apache.camel.management.JmxManagementStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.ManagementStrategyFactory;
import org.apache.camel.support.PropertyBindingSupport;

public class JmxManagementStrategyFactory
implements ManagementStrategyFactory {
    public ManagementStrategy create(CamelContext context, Map<String, Object> options) throws Exception {
        DefaultManagementAgent agent = new DefaultManagementAgent(context);
        if (options != null) {
            PropertyBindingSupport.bindProperties((CamelContext)context, (Object)((Object)agent), options);
        }
        return new JmxManagementStrategy(context, agent);
    }

    public LifecycleStrategy createLifecycle(CamelContext context) throws Exception {
        return new JmxManagementLifecycleStrategy(context);
    }

    public void setupManagement(CamelContext camelContext, ManagementStrategy strategy, LifecycleStrategy lifecycle) {
        camelContext.setManagementStrategy(strategy);
        if (!camelContext.getLifecycleStrategies().isEmpty()) {
            camelContext.getLifecycleStrategies().removeIf(s -> s instanceof JmxManagementLifecycleStrategy);
        }
        camelContext.getLifecycleStrategies().add(0, lifecycle);
    }
}

