/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Ordered;
import org.apache.camel.Processor;
import org.apache.camel.management.DelegatePerformanceCounter;
import org.apache.camel.management.PerformanceCounter;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.spi.ManagementInterceptStrategy;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.util.StopWatch;

public class DefaultInstrumentationProcessor
extends DelegateAsyncProcessor
implements ManagementInterceptStrategy.InstrumentationProcessor<StopWatch>,
Ordered {
    private PerformanceCounter counter;
    private String type;

    public DefaultInstrumentationProcessor(String type, Processor processor) {
        super(processor);
        this.type = type;
    }

    public DefaultInstrumentationProcessor(String type) {
        super((AsyncProcessor)null);
        this.type = type;
    }

    public void setCounter(Object counter) {
        ManagedPerformanceCounter mpc = null;
        if (counter instanceof ManagedPerformanceCounter) {
            mpc = (ManagedPerformanceCounter)counter;
        }
        if (this.counter instanceof DelegatePerformanceCounter) {
            ((DelegatePerformanceCounter)this.counter).setCounter(mpc);
        } else if (mpc != null) {
            this.counter = mpc;
        } else if (counter instanceof PerformanceCounter) {
            this.counter = (PerformanceCounter)counter;
        }
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        StopWatch watch;
        StopWatch stopWatch = watch = this.counter != null && this.counter.isStatisticsEnabled() ? new StopWatch() : null;
        if (watch != null) {
            this.beginTime(exchange);
        }
        return this.processor.process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                try {
                    if (watch != null) {
                        DefaultInstrumentationProcessor.this.recordTime(exchange, watch.taken());
                    }
                }
                finally {
                    callback.done(doneSync);
                }
            }

            public String toString() {
                return DefaultInstrumentationProcessor.this.toString();
            }
        });
    }

    protected void beginTime(Exchange exchange) {
        this.counter.processExchange(exchange);
    }

    protected void recordTime(Exchange exchange, long duration) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("{}Recording duration: {} millis for exchange: {}", new Object[]{this.type != null ? this.type + ": " : "", duration, exchange});
        }
        if (!exchange.isFailed() && exchange.getException() == null) {
            this.counter.completedExchange(exchange, duration);
        } else {
            this.counter.failedExchange(exchange);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public StopWatch before(Exchange exchange) throws Exception {
        StopWatch answer;
        StopWatch stopWatch = answer = this.counter != null && this.counter.isStatisticsEnabled() ? new StopWatch() : null;
        if (answer != null) {
            this.beginTime(exchange);
        }
        return answer;
    }

    public void after(Exchange exchange, StopWatch watch) throws Exception {
        if (watch != null) {
            this.recordTime(exchange, watch.taken());
        }
    }

    public String toString() {
        return "InstrumentProcessorAdvice";
    }

    public int getOrder() {
        return 0x7FFFFFFD;
    }
}

