/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb3.converters;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.spi.TypeConverterRegistry;
import org.bson.Document;

@Converter(loader=true)
public final class MongoDbFallbackConverter {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private MongoDbFallbackConverter() {
    }

    @Converter(fallback=true)
    public static Object convertTo(Class<?> type, Exchange exchange, Object value, TypeConverterRegistry registry) throws InvalidPayloadException {
        if (String.class == value.getClass()) {
            if (type == DBObject.class) {
                Object out = JSON.parse((String)value.toString());
                if (out instanceof DBObject) {
                    return out;
                }
                throw new InvalidPayloadException(exchange, type);
            }
            if (type == BasicDBList.class) {
                Object out = JSON.parse((String)value.toString());
                if (out instanceof BasicDBList) {
                    return out;
                }
                throw new InvalidPayloadException(exchange, type);
            }
            if (type == BasicDBObject.class) {
                Object out = JSON.parse((String)value.toString());
                if (out instanceof BasicDBObject) {
                    return out;
                }
                throw new InvalidPayloadException(exchange, type);
            }
        }
        if (type == DBObject.class) {
            Map m = (Map)OBJECT_MAPPER.convertValue(value, Map.class);
            MongoDbFallbackConverter.mapMongoDBBigDecimalIssue(m);
            return new BasicDBObject(m);
        }
        if (type == Document.class) {
            Map m = (Map)OBJECT_MAPPER.convertValue(value, Map.class);
            MongoDbFallbackConverter.mapMongoDBBigDecimalIssue(m);
            return new Document(m);
        }
        return null;
    }

    private static void mapMongoDBBigDecimalIssue(Map<?, ?> m) {
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof BigDecimal)) continue;
            v = Double.valueOf(v.toString());
            entry.setValue(v);
        }
    }
}

