/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb3.converters;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.mongodb3.converters.MongoDbBasicConverters;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.bson.Document;

public class MongoDbBasicConvertersLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        this.addTypeConverter(registry, List.class, String.class, false, (type, exchange, value) -> MongoDbBasicConverters.fromStringToList((String)value));
        this.addTypeConverter(registry, Map.class, Document.class, false, (type, exchange, value) -> MongoDbBasicConverters.fromDocumentToMap((Document)value));
        this.addTypeConverter(registry, Document.class, File.class, false, (type, exchange, value) -> MongoDbBasicConverters.fromFileToDocument((File)value, exchange));
        this.addTypeConverter(registry, Document.class, InputStream.class, false, (type, exchange, value) -> MongoDbBasicConverters.fromInputStreamToDocument((InputStream)value, exchange));
        this.addTypeConverter(registry, Document.class, String.class, false, (type, exchange, value) -> MongoDbBasicConverters.fromStringToDocument((String)value));
        this.addTypeConverter(registry, Document.class, Map.class, false, (type, exchange, value) -> MongoDbBasicConverters.fromMapToDocument((Map)value));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

