/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd.springboot.cloud;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.camel.CamelContext;
import org.apache.camel.TypeConverter;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.component.etcd.cloud.EtcdServiceDiscoveryFactory;
import org.apache.camel.model.cloud.springboot.EtcdServiceCallServiceDiscoveryConfigurationProperties;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.apache.camel.support.IntrospectionSupport;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ConditionalOnBean(value={CamelAutoConfiguration.class})
@Conditional(value={Condition.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={EtcdServiceCallServiceDiscoveryConfigurationProperties.class})
public class EtcdCloudAutoConfiguration {
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private EtcdServiceCallServiceDiscoveryConfigurationProperties configuration;
    @Autowired
    private ConfigurableBeanFactory beanFactory;

    @Lazy
    @Bean(name={"etcd-service-discovery"})
    @ConditionalOnClass(value={CamelContext.class})
    public ServiceDiscovery configureServiceDiscoveryFactory() throws Exception {
        EtcdServiceDiscoveryFactory factory = new EtcdServiceDiscoveryFactory();
        IntrospectionSupport.setProperties((CamelContext)this.camelContext, (TypeConverter)this.camelContext.getTypeConverter(), (Object)factory, (Map)IntrospectionSupport.getNonNullProperties((Object)this.configuration));
        return factory.newInstance(this.camelContext);
    }

    @PostConstruct
    public void postConstruct() {
        if (this.beanFactory != null) {
            HashMap parameters = new HashMap();
            for (Map.Entry entry : this.configuration.getConfigurations().entrySet()) {
                parameters.clear();
                EtcdServiceDiscoveryFactory factory = new EtcdServiceDiscoveryFactory();
                try {
                    IntrospectionSupport.getProperties(entry.getValue(), parameters, null, (boolean)false);
                    IntrospectionSupport.setProperties((CamelContext)this.camelContext, (TypeConverter)this.camelContext.getTypeConverter(), (Object)factory, parameters);
                    this.beanFactory.registerSingleton((String)entry.getKey(), (Object)factory.newInstance(this.camelContext));
                }
                catch (Exception e) {
                    throw new BeanCreationException((String)entry.getKey(), e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static class Condition
    extends GroupCondition {
        public Condition() {
            super("camel.cloud.etcd", "camel.cloud.etcd.service-discovery");
        }
    }
}

