/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.jaxb.FallbackTypeConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public class FallbackTypeConverterLoader
implements TypeConverterLoader {
    private volatile FallbackTypeConverter fallbackTypeConverter;

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerFallbackConverters(registry);
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        this.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> this.getFallbackTypeConverter().convertTo(type, exchange, value, registry));
    }

    private void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) {
        registry.addFallbackTypeConverter((TypeConverter)new SimpleTypeConverter(allowNull, method), canPromote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FallbackTypeConverter getFallbackTypeConverter() {
        if (this.fallbackTypeConverter == null) {
            FallbackTypeConverterLoader fallbackTypeConverterLoader = this;
            synchronized (fallbackTypeConverterLoader) {
                if (this.fallbackTypeConverter == null) {
                    this.fallbackTypeConverter = new FallbackTypeConverter();
                }
            }
        }
        return this.fallbackTypeConverter;
    }
}

