/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.lucene;

import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import org.apache.camel.catalog.SuggestionStrategy;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.PlainTextDictionary;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class LuceneSuggestionStrategy
implements SuggestionStrategy {
    private int maxSuggestions = 3;

    public String[] suggestEndpointOptions(Set<String> names, String unknownOption) {
        StringBuilder sb = new StringBuilder();
        for (String name : names) {
            sb.append(name);
            sb.append("\n");
        }
        StringReader reader = new StringReader(sb.toString());
        try {
            PlainTextDictionary words = new PlainTextDictionary((Reader)reader);
            RAMDirectory dir = new RAMDirectory();
            SpellChecker checker = new SpellChecker((Directory)dir);
            checker.indexDictionary((Dictionary)words, new IndexWriterConfig((Analyzer)new KeywordAnalyzer()), false);
            return checker.suggestSimilar(unknownOption, this.maxSuggestions);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

