/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.thrift.server;

import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.transport.TNonblockingServerTransport;

public class ThriftHsHaServer
extends THsHaServer {
    private final CamelContext context;
    private final ExecutorService startExecutor;

    public ThriftHsHaServer(Args args) {
        super((THsHaServer.Args)args);
        this.context = args.context;
        this.startExecutor = args.startThreadPool;
    }

    public void serve() throws IllegalArgumentException {
        if (!this.startThreads()) {
            throw new IllegalArgumentException("Failed to start selector thread!");
        }
        if (!this.startListening()) {
            throw new IllegalArgumentException("Failed to start listening on server socket!");
        }
        this.startExecutor.execute(() -> {
            this.setServing(true);
            this.waitForShutdown();
            this.setServing(false);
            this.stopListening();
        });
    }

    public void stop() {
        super.stop();
        this.context.getExecutorServiceManager().shutdownGraceful(this.startExecutor);
    }

    protected void waitForShutdown() {
        this.joinSelector();
        this.context.getExecutorServiceManager().shutdownGraceful(this.getInvoker());
    }

    public static class Args
    extends THsHaServer.Args {
        private ExecutorService startThreadPool;
        private CamelContext context;

        public Args(TNonblockingServerTransport transport) {
            super(transport);
        }

        public Args startThreadPool(ExecutorService startThreadPool) {
            this.startThreadPool = startThreadPool;
            return this;
        }

        public Args context(CamelContext context) {
            this.context = context;
            return this;
        }
    }
}

