/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.thrift;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.camel.CamelContext;
import org.apache.camel.component.thrift.ThriftCompressionType;
import org.apache.camel.component.thrift.ThriftExchangeProtocol;
import org.apache.camel.component.thrift.ThriftNegotiationType;
import org.apache.camel.component.thrift.client.AsyncClientMethodCallback;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.ReflectionHelper;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TSimpleJSONProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TZlibTransport;

public final class ThriftUtils {
    private ThriftUtils() {
    }

    public static String extractServiceName(String service) {
        return service.substring(service.lastIndexOf(".") + 1);
    }

    public static String extractServicePackage(String service) {
        return service.substring(0, service.lastIndexOf("."));
    }

    public static Object constructClientInstance(String packageName, String serviceName, TTransport transport, ThriftExchangeProtocol exchangeProtocol, ThriftNegotiationType negotiationType, ThriftCompressionType compressionType, CamelContext context) {
        Object clientInstance = null;
        Class[] constructorParamTypes = new Class[]{TProtocol.class};
        Object[] constructorParamValues = new Object[]{ThriftUtils.constructSyncProtocol(transport, exchangeProtocol, negotiationType, compressionType)};
        String clientClassName = packageName + "." + serviceName + "$" + "Client";
        try {
            Class clientClass = context.getClassResolver().resolveMandatoryClass(clientClassName);
            Constructor clientConstructor = clientClass.getConstructor(constructorParamTypes);
            clientInstance = clientConstructor.newInstance(constructorParamValues);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Thrift client class not found: " + clientClassName);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Thrift client class constructor not found: " + clientClassName);
        }
        catch (IllegalAccessException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        return clientInstance;
    }

    public static Object constructAsyncClientInstance(String packageName, String serviceName, TNonblockingTransport transport, ThriftExchangeProtocol exchangeProtocol, CamelContext context) {
        Object asynClientInstance = null;
        Class[] getterParamTypes = new Class[]{TNonblockingTransport.class};
        Class[] constructorParamTypes = new Class[]{TAsyncClientManager.class, TProtocolFactory.class};
        String clientClassName = packageName + "." + serviceName + "$" + "AsyncClient" + "$" + "Factory";
        try {
            Class clientClass = context.getClassResolver().resolveMandatoryClass(clientClassName);
            Constructor factoryConstructor = clientClass.getConstructor(constructorParamTypes);
            Object factoryInstance = factoryConstructor.newInstance(new TAsyncClientManager(), ThriftUtils.constructAsyncProtocol(exchangeProtocol));
            Method asyncClientGetter = ReflectionHelper.findMethod((Class)clientClass, (String)"getAsyncClient", (Class[])getterParamTypes);
            if (asyncClientGetter == null) {
                throw new IllegalArgumentException("Thrift async client getter not found: " + clientClassName + "." + "getAsyncClient");
            }
            asynClientInstance = ObjectHelper.invokeMethod((Method)asyncClientGetter, factoryInstance, (Object[])new Object[]{transport});
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Thrift sync client class not found: " + clientClassName);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Thrift sync client factory class not found: " + clientClassName);
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        return asynClientInstance;
    }

    public static Object invokeSyncMethod(Object syncClient, String invokeMethod, Object request) {
        Object[] params = ThriftUtils.convertObjects2Primitives(request, null);
        Class[] paramsTypes = (Class[])params[0];
        Object[] paramsValues = (Object[])params[1];
        Method method = ReflectionHelper.findMethod(syncClient.getClass(), (String)invokeMethod, (Class[])paramsTypes);
        if (method == null) {
            throw new IllegalArgumentException("Thrift service client method not found: " + syncClient.getClass().getName() + "." + invokeMethod + ThriftUtils.printParamsTypes(paramsTypes));
        }
        Object result = ObjectHelper.invokeMethod((Method)method, (Object)syncClient, (Object[])paramsValues);
        return result;
    }

    public static void invokeAsyncMethod(Object asyncClient, String invokeMethod, Object request, AsyncClientMethodCallback methodCallback) {
        Object[] params = ThriftUtils.convertObjects2Primitives(request, methodCallback);
        Class[] paramsTypes = (Class[])params[0];
        Object[] paramsValues = (Object[])params[1];
        Method method = ReflectionHelper.findMethod(asyncClient.getClass(), (String)invokeMethod, (Class[])paramsTypes);
        if (method == null) {
            throw new IllegalArgumentException("Thrift service client method not found: " + asyncClient.getClass().getName() + "." + invokeMethod + ThriftUtils.printParamsTypes(paramsTypes));
        }
        ObjectHelper.invokeMethod((Method)method, (Object)asyncClient, (Object[])paramsValues);
    }

    public static Class getServerInterface(String packageName, String serviceName, boolean isSyncInterface, CamelContext context) {
        String serverInterfaceName = null;
        Class serverInterface = null;
        try {
            serverInterfaceName = isSyncInterface ? packageName + "." + serviceName + "$" + "Iface" : packageName + "." + serviceName + "$" + "AsyncIface";
            serverInterface = context.getClassResolver().resolveMandatoryClass(serverInterfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to find server interface implementation for: " + serverInterfaceName);
        }
        return serverInterface;
    }

    public static Object constructServerProcessor(String packageName, String serviceName, Object serverImplementation, boolean isSyncProcessor, CamelContext context) {
        String processorClassName = null;
        Class serverInterface = null;
        Object processorInstance = null;
        try {
            if (isSyncProcessor) {
                processorClassName = packageName + "." + serviceName + "$" + "Processor";
                serverInterface = ThriftUtils.getServerInterface(packageName, serviceName, isSyncProcessor, context);
            } else {
                processorClassName = packageName + "." + serviceName + "$" + "AsyncProcessor";
                serverInterface = ThriftUtils.getServerInterface(packageName, serviceName, isSyncProcessor, context);
            }
            Class processorClass = context.getClassResolver().resolveMandatoryClass(processorClassName);
            Constructor procesorConstructor = processorClass.getConstructor(serverInterface);
            processorInstance = procesorConstructor.newInstance(serverImplementation);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to find server processor for: " + processorClassName);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException("Processor class instance not found for: " + processorClassName);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        return processorInstance;
    }

    private static TProtocol constructSyncProtocol(TTransport transport, ThriftExchangeProtocol exchangeProtocol, ThriftNegotiationType negotiationType, ThriftCompressionType compressionType) {
        if (negotiationType == ThriftNegotiationType.SSL) {
            return new TBinaryProtocol(transport);
        }
        if (compressionType == ThriftCompressionType.ZLIB) {
            return new TBinaryProtocol((TTransport)new TZlibTransport(transport));
        }
        switch (exchangeProtocol) {
            case BINARY: {
                return new TBinaryProtocol((TTransport)new TFramedTransport(transport));
            }
            case JSON: {
                return new TJSONProtocol((TTransport)new TFramedTransport(transport));
            }
            case SJSON: {
                return new TSimpleJSONProtocol((TTransport)new TFramedTransport(transport));
            }
            case COMPACT: {
                return new TCompactProtocol((TTransport)new TFramedTransport(transport));
            }
        }
        throw new IllegalArgumentException("Exchange protocol " + (Object)((Object)exchangeProtocol) + " not implemented");
    }

    private static TProtocolFactory constructAsyncProtocol(ThriftExchangeProtocol exchangeProtocol) {
        switch (exchangeProtocol) {
            case BINARY: {
                return new TBinaryProtocol.Factory();
            }
            case JSON: {
                return new TJSONProtocol.Factory();
            }
            case SJSON: {
                return new TSimpleJSONProtocol.Factory();
            }
            case COMPACT: {
                return new TCompactProtocol.Factory();
            }
        }
        throw new IllegalArgumentException("Exchange protocol " + (Object)((Object)exchangeProtocol) + " not implemented");
    }

    public static Class findMethodReturnType(Class clazz, String name) {
        for (Method method : clazz.getMethods()) {
            if (!name.equals(method.getName()) || method.getParameterTypes()[0].equals(Object.class)) continue;
            return method.getParameterTypes()[0];
        }
        return null;
    }

    private static String printParamsTypes(Class[] paramsTypes) {
        StringJoiner joiner = new StringJoiner(",");
        for (Class paramType : paramsTypes) {
            joiner.add(paramType == null ? "null" : paramType.getName());
        }
        return "(" + joiner.toString() + ")";
    }

    private static Object[] convertObjects2Primitives(Object request, AsyncClientMethodCallback methodCallback) {
        Class[] paramsTypes = null;
        Object[] paramsValues = null;
        int paramListSize = 1;
        if (request instanceof List) {
            List paramList = (List)request;
            paramListSize = paramList.size() + (methodCallback == null ? 0 : 1);
            paramsTypes = new Class[paramListSize];
            paramsValues = new Object[paramListSize];
            int idx = 0;
            for (Object param : paramList) {
                paramsTypes[idx] = param instanceof Short ? Short.TYPE : (param instanceof Long ? Long.TYPE : (param instanceof Integer ? Integer.TYPE : (param instanceof Double ? Double.TYPE : (param instanceof Byte ? Byte.TYPE : (param instanceof Boolean ? Boolean.TYPE : (param instanceof List ? List.class : (param instanceof Set ? Set.class : (param instanceof Map ? Map.class : (param instanceof ByteBuffer ? ByteBuffer.class : param.getClass())))))))));
                paramsValues[idx] = param;
                ++idx;
            }
        } else if (request != null) {
            paramListSize = methodCallback == null ? 1 : 2;
            paramsTypes = new Class[paramListSize];
            paramsValues = new Object[paramListSize];
            paramsTypes[0] = request.getClass();
            paramsValues[0] = request;
        } else {
            paramListSize = methodCallback == null ? 0 : 1;
            paramsTypes = new Class[paramListSize];
            paramsValues = new Object[paramListSize];
        }
        if (methodCallback != null) {
            paramsTypes[paramListSize - 1] = AsyncMethodCallback.class;
            paramsValues[paramListSize - 1] = methodCallback;
        }
        return new Object[]{paramsTypes, paramsValues};
    }
}

