/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.thrift;

import java.io.IOException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProducer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.thrift.ThriftConfiguration;
import org.apache.camel.component.thrift.ThriftEndpoint;
import org.apache.camel.component.thrift.ThriftNegotiationType;
import org.apache.camel.component.thrift.ThriftUtils;
import org.apache.camel.component.thrift.client.AsyncClientMethodCallback;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TNonblockingSocket;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class ThriftProducer
extends DefaultAsyncProducer
implements AsyncProducer {
    protected final ThriftConfiguration configuration;
    protected final ThriftEndpoint endpoint;
    private TTransport syncTransport;
    private TNonblockingTransport asyncTransport;
    private Object thriftClient;

    public ThriftProducer(ThriftEndpoint endpoint, ThriftConfiguration configuration) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Message message = exchange.getIn();
        try {
            ThriftUtils.invokeAsyncMethod(this.thriftClient, this.configuration.getMethod(), message.getBody(), new AsyncClientMethodCallback(exchange, callback));
        }
        catch (Exception e) {
            if (e.getCause() instanceof TException) {
                exchange.setException(e.getCause());
            } else {
                exchange.setException((Throwable)e);
            }
            callback.done(true);
            return true;
        }
        return false;
    }

    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getIn();
        try {
            Object outBody = ThriftUtils.invokeSyncMethod(this.thriftClient, this.configuration.getMethod(), message.getBody());
            exchange.getOut().setBody(outBody);
        }
        catch (Exception e) {
            if (e.getCause() instanceof TException) {
                exchange.setException(e.getCause());
            }
            throw new Exception(e);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.configuration.getNegotiationType() == ThriftNegotiationType.SSL) {
            if (!this.endpoint.isSynchronous()) {
                throw new IllegalArgumentException("The SSL negotiation type requires to set syncronous communication mode");
            }
            if (this.syncTransport == null) {
                this.initializeSslTransport();
                this.log.info("Getting synchronous secured client implementation");
                this.thriftClient = ThriftUtils.constructClientInstance(this.endpoint.getServicePackage(), this.endpoint.getServiceName(), this.syncTransport, this.configuration.getExchangeProtocol(), this.configuration.getNegotiationType(), this.configuration.getCompressionType(), this.endpoint.getCamelContext());
            }
        } else if (this.endpoint.isSynchronous()) {
            if (this.syncTransport == null) {
                this.initializeSyncTransport();
                this.log.info("Getting synchronous client implementation");
                this.thriftClient = ThriftUtils.constructClientInstance(this.endpoint.getServicePackage(), this.endpoint.getServiceName(), this.syncTransport, this.configuration.getExchangeProtocol(), this.configuration.getNegotiationType(), this.configuration.getCompressionType(), this.endpoint.getCamelContext());
            }
        } else if (this.asyncTransport == null) {
            this.initializeAsyncTransport();
            this.log.info("Getting asynchronous client implementation");
            this.thriftClient = ThriftUtils.constructAsyncClientInstance(this.endpoint.getServicePackage(), this.endpoint.getServiceName(), this.asyncTransport, this.configuration.getExchangeProtocol(), this.endpoint.getCamelContext());
        }
    }

    protected void doStop() throws Exception {
        if (this.syncTransport != null) {
            this.log.debug("Terminating synchronous transport the remote Thrift server");
            this.syncTransport.close();
            this.syncTransport = null;
        } else if (this.asyncTransport != null) {
            this.log.debug("Terminating asynchronous transport the remote Thrift server");
            this.asyncTransport.close();
            this.asyncTransport = null;
        }
        super.doStop();
    }

    protected void initializeSyncTransport() throws TTransportException {
        if (ObjectHelper.isEmpty((Object)this.configuration.getHost()) || ObjectHelper.isEmpty((Object)this.configuration.getPort())) {
            throw new IllegalArgumentException("No connection properties (host, port) specified");
        }
        this.log.info("Creating transport to the remote Thrift server {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        this.syncTransport = new TSocket(this.configuration.getHost(), this.configuration.getPort());
        this.syncTransport.open();
    }

    protected void initializeAsyncTransport() throws IOException, TTransportException {
        if (ObjectHelper.isEmpty((Object)this.configuration.getHost()) || ObjectHelper.isEmpty((Object)this.configuration.getPort())) {
            throw new IllegalArgumentException("No connection properties (host, port) specified");
        }
        this.log.info("Creating transport to the remote Thrift server {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        this.asyncTransport = new TNonblockingSocket(this.configuration.getHost(), this.configuration.getPort());
    }

    protected void initializeSslTransport() throws TTransportException, IOException {
        TSSLTransportFactory.TSSLTransportParameters sslParams;
        if (!ObjectHelper.isEmpty((Object)this.configuration.getHost()) && !ObjectHelper.isEmpty((Object)this.configuration.getPort())) {
            SSLContextParameters sslParameters = this.configuration.getSslParameters();
            if (sslParameters == null) {
                throw new IllegalArgumentException("SSL parameters must be initialized if negotiation type is set to " + (Object)((Object)this.configuration.getNegotiationType()));
            }
            ObjectHelper.notNull((Object)sslParameters.getSecureSocketProtocol(), (String)"Security protocol");
            ObjectHelper.notNull((Object)sslParameters.getTrustManagers().getKeyStore().getResource(), (String)"Trust store path");
            ObjectHelper.notNull((Object)sslParameters.getTrustManagers().getKeyStore().getPassword(), (String)"Trust store password");
            this.log.info("Creating secured transport to the remote Thrift server {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
            ClassResolver classResolver = this.endpoint.getCamelContext().getClassResolver();
            sslParams = new TSSLTransportFactory.TSSLTransportParameters(sslParameters.getSecureSocketProtocol(), sslParameters.getCipherSuites() == null ? null : (String[])sslParameters.getCipherSuites().getCipherSuite().stream().toArray(String[]::new));
            if (ObjectHelper.isNotEmpty((Object)sslParameters.getTrustManagers().getProvider()) && ObjectHelper.isNotEmpty((Object)sslParameters.getTrustManagers().getKeyStore().getType())) {
                sslParams.setTrustStore(ResourceHelper.resolveResourceAsInputStream((ClassResolver)classResolver, (String)sslParameters.getTrustManagers().getKeyStore().getResource()), sslParameters.getTrustManagers().getKeyStore().getPassword(), sslParameters.getTrustManagers().getProvider(), sslParameters.getTrustManagers().getKeyStore().getType());
            } else {
                sslParams.setTrustStore(sslParameters.getTrustManagers().getKeyStore().getResource(), sslParameters.getTrustManagers().getKeyStore().getPassword());
            }
        } else {
            throw new IllegalArgumentException("No connection properties (host, port) specified");
        }
        this.syncTransport = TSSLTransportFactory.getClientSocket((String)this.configuration.getHost(), (int)this.configuration.getPort(), (int)this.configuration.getClientTimeout(), (TSSLTransportFactory.TSSLTransportParameters)sslParams);
    }
}

