/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.karaf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Language;
import org.apache.karaf.features.FeaturesService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.ProbeBuilder;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.karaf.container.internal.JavaVersionUtil;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.options.extra.VMOption;
import org.ops4j.pax.tinybundles.core.TinyBundle;
import org.ops4j.pax.tinybundles.core.TinyBundles;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFeatureTest {
    public static final Long SERVICE_TIMEOUT = 30000L;
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractFeatureTest.class);
    @Inject
    protected BundleContext bundleContext;
    @Inject
    protected BlueprintContainer blueprintContainer;
    @Inject
    protected FeaturesService featuresService;

    @ProbeBuilder
    public TestProbeBuilder probeConfiguration(TestProbeBuilder probe) {
        probe.setHeader("DynamicImport-Package", "*");
        return probe;
    }

    @Before
    public void setUp() throws Exception {
        LOG.info("setUp() using BundleContext: {}", (Object)this.bundleContext);
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("tearDown()");
    }

    protected Bundle installBlueprintAsBundle(String name, URL url, boolean start) throws BundleException {
        return this.installBlueprintAsBundle(name, url, start, bundle -> {});
    }

    protected Bundle installBlueprintAsBundle(String name, URL url, boolean start, Consumer<Object> consumer) throws BundleException {
        TinyBundle bundle = TinyBundles.bundle();
        bundle.add("OSGI-INF/blueprint/blueprint-" + name.toLowerCase(Locale.ENGLISH) + ".xml", url);
        bundle.set("Manifest-Version", "2").set("Bundle-ManifestVersion", "2").set("Bundle-SymbolicName", name).set("Bundle-Version", "1.0.0");
        consumer.accept(bundle);
        Bundle answer = this.bundleContext.installBundle(name, bundle.build());
        if (start) {
            answer.start();
        }
        return answer;
    }

    protected Bundle installSpringAsBundle(String name, URL url, boolean start) throws BundleException {
        return this.installSpringAsBundle(name, url, start, bundle -> {});
    }

    protected Bundle installSpringAsBundle(String name, URL url, boolean start, Consumer<Object> consumer) throws BundleException {
        TinyBundle bundle = TinyBundles.bundle();
        bundle.add("META-INF/spring/spring-" + name.toLowerCase(Locale.ENGLISH) + ".xml", url);
        bundle.set("Manifest-Version", "2").set("Bundle-ManifestVersion", "2").set("Bundle-SymbolicName", name).set("Bundle-Version", "1.0.0");
        consumer.accept(bundle);
        Bundle answer = this.bundleContext.installBundle(name, bundle.build());
        if (start) {
            answer.start();
        }
        return answer;
    }

    protected void installCamelFeature(String mainFeature) throws Exception {
        if (!mainFeature.startsWith("camel-")) {
            mainFeature = "camel-" + mainFeature;
        }
        LOG.info("Install main feature: {}", (Object)mainFeature);
        this.featuresService.installFeature(mainFeature, EnumSet.of(FeaturesService.Option.NoAutoRefreshBundles));
    }

    protected void overridePropertiesWithConfigAdmin(String pid, Properties props) throws IOException {
        ConfigurationAdmin configAdmin = this.getOsgiService(this.bundleContext, ConfigurationAdmin.class);
        Configuration config = configAdmin.getConfiguration(pid, null);
        if (config == null) {
            throw new IllegalArgumentException("Cannot find configuration with pid " + pid + " in OSGi ConfigurationAdmin service.");
        }
        Dictionary currentProperties = config.getProperties();
        Properties newProps = new Properties();
        if (currentProperties == null) {
            currentProperties = newProps;
        }
        Enumeration ek = currentProperties.keys();
        while (ek.hasMoreElements()) {
            String k = (String)ek.nextElement();
            ((Dictionary)newProps).put(k, currentProperties.get(k));
        }
        for (String p : props.stringPropertyNames()) {
            ((Dictionary)newProps).put(p, props.getProperty(p));
        }
        LOG.info("Updating ConfigAdmin {} by overriding properties {}", (Object)config, (Object)newProps);
        config.update((Dictionary)newProps);
    }

    protected void testComponent(String component) throws Exception {
        this.testComponent("camel-" + component, component);
    }

    protected void testComponent(String mainFeature, String component) throws Exception {
        LOG.info("Looking up CamelContext(myCamel) in OSGi Service Registry");
        this.installCamelFeature(mainFeature);
        CamelContext camelContext = AbstractFeatureTest.getOsgiService(this.bundleContext, CamelContext.class, "(camel.context.name=myCamel)", SERVICE_TIMEOUT);
        Assert.assertNotNull((String)"Cannot find CamelContext with name myCamel", (Object)camelContext);
        LOG.info("Getting Camel component: {}", (Object)component);
        Component comp = camelContext.getComponent(component, true, false);
        Assert.assertNotNull((String)("Cannot get component with name: " + component), (Object)comp);
        LOG.info("Found Camel component: {} instance: {} with className: {}", new Object[]{component, comp, comp.getClass()});
    }

    protected void testDataFormat(String dataFormat) throws Exception {
        this.testDataFormat("camel-" + dataFormat, dataFormat);
    }

    protected void testDataFormat(String mainFeature, String dataFormat) throws Exception {
        LOG.info("Looking up CamelContext(myCamel) in OSGi Service Registry");
        this.installCamelFeature(mainFeature);
        CamelContext camelContext = AbstractFeatureTest.getOsgiService(this.bundleContext, CamelContext.class, "(camel.context.name=myCamel)", SERVICE_TIMEOUT);
        Assert.assertNotNull((String)"Cannot find CamelContext with name myCamel", (Object)camelContext);
        LOG.info("Getting Camel dataformat: {}", (Object)dataFormat);
        DataFormat df = camelContext.resolveDataFormat(dataFormat);
        Assert.assertNotNull((String)("Cannot get dataformat with name: " + dataFormat), (Object)df);
        LOG.info("Found Camel dataformat: {} instance: {} with className: {}", new Object[]{dataFormat, df, df.getClass()});
    }

    protected void testLanguage(String language) throws Exception {
        this.testLanguage("camel-" + language, language);
    }

    protected void testLanguage(String mainFeature, String language) throws Exception {
        LOG.info("Looking up CamelContext(myCamel) in OSGi Service Registry");
        this.installCamelFeature(mainFeature);
        CamelContext camelContext = AbstractFeatureTest.getOsgiService(this.bundleContext, CamelContext.class, "(camel.context.name=myCamel)", 20000L);
        Assert.assertNotNull((String)"Cannot find CamelContext with name myCamel", (Object)camelContext);
        LOG.info("Getting Camel language: {}", (Object)language);
        Language lan = camelContext.resolveLanguage(language);
        Assert.assertNotNull((String)("Cannot get language with name: " + language), (Object)lan);
        LOG.info("Found Camel language: {} instance: {} with className: {}", new Object[]{language, lan, lan.getClass()});
    }

    public static String extractName(Class<?> clazz) {
        String name = clazz.getName();
        int id0 = name.indexOf("Camel") + "Camel".length();
        int id1 = name.indexOf("Test");
        StringBuilder sb = new StringBuilder();
        for (int i = id0; i < id1; ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c) && sb.length() > 0) {
                sb.append("-");
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static UrlReference getCamelKarafFeatureUrl() {
        return CoreOptions.mavenBundle().groupId("org.apache.camel.karaf").artifactId("apache-camel").version(AbstractFeatureTest.getCamelKarafFeatureVersion()).type("xml/features");
    }

    private static String getCamelKarafFeatureVersion() {
        String camelKarafFeatureVersion = System.getProperty("camelKarafFeatureVersion");
        if (camelKarafFeatureVersion == null) {
            throw new RuntimeException("Please specify the maven artifact version to use for org.apache.camel.karaf/apache-camel through the camelKarafFeatureVersion System property");
        }
        return camelKarafFeatureVersion;
    }

    private static void switchPlatformEncodingToUTF8() {
        try {
            System.setProperty("file.encoding", "UTF-8");
            Field charset = Charset.class.getDeclaredField("defaultCharset");
            charset.setAccessible(true);
            charset.set(null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getKarafVersion() {
        InputStream ins = AbstractFeatureTest.class.getResourceAsStream("/META-INF/maven/dependencies.properties");
        Properties p = new Properties();
        try {
            p.load(ins);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String karafVersion = p.getProperty("org.apache.karaf/apache-karaf/version");
        if (karafVersion == null) {
            karafVersion = System.getProperty("karafVersion");
        }
        if (karafVersion == null) {
            karafVersion = "4.1.0";
        }
        return karafVersion;
    }

    public static Option[] configure(String ... extra) {
        ArrayList<String> camel = new ArrayList<String>();
        camel.add("camel");
        if (extra != null && extra.length > 0) {
            for (String e : extra) {
                camel.add(e);
            }
        }
        String[] camelFeatures = camel.toArray(new String[camel.size()]);
        AbstractFeatureTest.switchPlatformEncodingToUTF8();
        String karafVersion = AbstractFeatureTest.getKarafVersion();
        LOG.info("*** Apache Karaf version is " + karafVersion + " ***");
        Option[] options = new Option[]{KarafDistributionOption.karafDistributionConfiguration().frameworkUrl((MavenUrlReference)CoreOptions.maven().groupId("org.apache.karaf").artifactId("apache-karaf").type("tar.gz").versionAsInProject()).karafVersion(karafVersion).name("Apache Karaf").useDeployFolder(false).unpackDirectory(new File("target/paxexam/unpack/")), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.INFO), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.configureConsole().ignoreRemoteShell(), CoreOptions.vmOption((String)"-Dfile.encoding=UTF-8"), KarafDistributionOption.editConfigurationFilePut((String)"etc/custom.properties", (String)"karaf.shutdown.port", (Object)"-1"), KarafDistributionOption.editConfigurationFilePut((String)"etc/custom.properties", (String)"karaf.log", (Object)"${karaf.data}/log"), CoreOptions.junitBundles(), KarafDistributionOption.features((UrlReference)AbstractFeatureTest.getCamelKarafFeatureUrl(), (String[])camelFeatures), CoreOptions.mavenBundle().groupId("org.apache.camel").artifactId("camel-test-karaf").versionAsInProject(), CoreOptions.when((JavaVersionUtil.getMajorVersion() >= 9 ? 1 : 0) != 0).useOptions(new Option[]{CoreOptions.systemProperty((String)"pax.exam.osgi.`unresolved.fail").value("true"), CoreOptions.systemProperty((String)"java.awt.headless").value("true"), new VMOption("--add-reads=java.xml=java.logging"), new VMOption("--add-exports=java.base/org.apache.karaf.specs.locator=java.xml,ALL-UNNAMED"), new VMOption("--patch-module"), new VMOption("java.base=lib/endorsed/org.apache.karaf.specs.locator-" + System.getProperty("karafVersion", "4.2.4") + ".jar"), new VMOption("--patch-module"), new VMOption("java.xml=lib/endorsed/org.apache.karaf.specs.java.xml-" + System.getProperty("karafVersion", "4.2.4") + ".jar"), new VMOption("--add-opens"), new VMOption("java.base/java.security=ALL-UNNAMED"), new VMOption("--add-opens"), new VMOption("java.base/java.net=ALL-UNNAMED"), new VMOption("--add-opens"), new VMOption("java.base/java.lang=ALL-UNNAMED"), new VMOption("--add-opens"), new VMOption("java.base/java.util=ALL-UNNAMED"), new VMOption("--add-opens"), new VMOption("java.naming/javax.naming.spi=ALL-UNNAMED"), new VMOption("--add-opens"), new VMOption("java.rmi/sun.rmi.transport.tcp=ALL-UNNAMED"), new VMOption("--add-exports=java.base/sun.net.www.protocol.http=ALL-UNNAMED"), new VMOption("--add-exports=java.base/sun.net.www.protocol.https=ALL-UNNAMED"), new VMOption("--add-exports=java.base/sun.net.www.protocol.jar=ALL-UNNAMED"), new VMOption("--add-exports=jdk.naming.rmi/com.sun.jndi.url.rmi=ALL-UNNAMED"), new VMOption("-classpath"), new VMOption("lib/jdk9plus/*" + File.pathSeparator + "lib/boot/*")})};
        return options;
    }

    protected <T> T getOsgiService(BundleContext bundleContext, Class<T> type) {
        return AbstractFeatureTest.getOsgiService(bundleContext, type, null, SERVICE_TIMEOUT);
    }

    protected <T> T getOsgiService(BundleContext bundleContext, Class<T> type, long timeout) {
        return AbstractFeatureTest.getOsgiService(bundleContext, type, null, timeout);
    }

    public static <T> T getOsgiService(BundleContext bundleContext, Class<T> type, String filter, long timeout) {
        try {
            String flt = filter != null ? (filter.startsWith("(") ? "(&(objectClass=" + type.getName() + ")" + filter + ")" : "(&(objectClass=" + type.getName() + ")(" + filter + "))") : "(objectClass=" + type.getName() + ")";
            Filter osgiFilter = FrameworkUtil.createFilter((String)flt);
            ServiceTracker tracker = new ServiceTracker(bundleContext, osgiFilter, null);
            tracker.open(true);
            Object svc = tracker.waitForService(timeout);
            if (svc == null) {
                Dictionary dic = bundleContext.getBundle().getHeaders();
                LOG.warn("Test bundle headers: " + AbstractFeatureTest.explode(dic));
                for (ServiceReference ref : AbstractFeatureTest.asCollection(bundleContext.getAllServiceReferences(null, null))) {
                    LOG.warn("ServiceReference: " + ref + ", bundle: " + ref.getBundle() + ", symbolicName: " + ref.getBundle().getSymbolicName());
                }
                for (ServiceReference ref : AbstractFeatureTest.asCollection(bundleContext.getAllServiceReferences(null, flt))) {
                    LOG.warn("Filtered ServiceReference: " + ref + ", bundle: " + ref.getBundle() + ", symbolicName: " + ref.getBundle().getSymbolicName());
                }
                throw new RuntimeException("Gave up waiting for service " + flt);
            }
            return type.cast(svc);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static String explode(Dictionary<?, ?> dictionary) {
        Enumeration<?> keys = dictionary.keys();
        StringBuilder result = new StringBuilder();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            result.append(String.format("%s=%s", key, dictionary.get(key)));
            if (!keys.hasMoreElements()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    private static Collection<ServiceReference> asCollection(ServiceReference[] references) {
        return references == null ? new ArrayList(0) : Arrays.asList(references);
    }
}

