/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4;

import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.io.ObjectInput;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.netty4.NettyConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.w3c.dom.Document;

public class NettyConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        this.addTypeConverter(registry, byte[].class, ByteBuf.class, false, (type, exchange, value) -> NettyConverter.toByteArray((ByteBuf)value, exchange));
        this.addTypeConverter(registry, ByteBuf.class, byte[].class, false, (type, exchange, value) -> NettyConverter.toByteBuffer((byte[])value));
        this.addTypeConverter(registry, ByteBuf.class, String.class, false, (type, exchange, value) -> NettyConverter.toByteBuffer((String)value, exchange));
        this.addTypeConverter(registry, InputStream.class, ByteBuf.class, false, (type, exchange, value) -> NettyConverter.toInputStream((ByteBuf)value, exchange));
        this.addTypeConverter(registry, ObjectInput.class, ByteBuf.class, false, (type, exchange, value) -> NettyConverter.toObjectInput((ByteBuf)value, exchange));
        this.addTypeConverter(registry, String.class, ByteBuf.class, false, (type, exchange, value) -> NettyConverter.toString((ByteBuf)value, exchange));
        this.addTypeConverter(registry, DOMSource.class, ByteBuf.class, false, (type, exchange, value) -> NettyConverter.toDOMSource((ByteBuf)value, exchange));
        this.addTypeConverter(registry, SAXSource.class, ByteBuf.class, false, (type, exchange, value) -> NettyConverter.toSAXSource((ByteBuf)value, exchange));
        this.addTypeConverter(registry, StAXSource.class, ByteBuf.class, false, (type, exchange, value) -> NettyConverter.toStAXSource((ByteBuf)value, exchange));
        this.addTypeConverter(registry, StreamSource.class, ByteBuf.class, false, (type, exchange, value) -> NettyConverter.toStreamSource((ByteBuf)value, exchange));
        this.addTypeConverter(registry, Document.class, ByteBuf.class, false, (type, exchange, value) -> NettyConverter.toDocument((ByteBuf)value, exchange));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

