/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd;

import java.util.Map;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.etcd.EtcdConfiguration;
import org.apache.camel.component.etcd.EtcdKeysEndpoint;
import org.apache.camel.component.etcd.EtcdNamespace;
import org.apache.camel.component.etcd.EtcdStatsEndpoint;
import org.apache.camel.component.etcd.EtcdWatchEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.StringHelper;

@Component(value="etcd")
public class EtcdComponent
extends DefaultComponent
implements SSLContextParametersAware {
    @Metadata(label="advanced")
    private EtcdConfiguration configuration = new EtcdConfiguration();
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public EtcdComponent() {
    }

    public EtcdComponent(CamelContext context) {
        super(context);
    }

    public String getUris() {
        return this.configuration.getUris();
    }

    public void setUris(String uris) {
        this.configuration.setUris(uris);
    }

    public SSLContextParameters getSslContextParameters() {
        return this.configuration.getSslContextParameters();
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.configuration.setSslContextParameters(sslContextParameters);
    }

    public String getUserName() {
        return this.configuration.getUserName();
    }

    public void setUserName(String userName) {
        this.configuration.setUserName(userName);
    }

    public String getPassword() {
        return this.configuration.getPassword();
    }

    public void setPassword(String password) {
        this.configuration.setPassword(password);
    }

    public EtcdConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EtcdConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String ns = StringHelper.before((String)remaining, (String)"/");
        String path = StringHelper.after((String)remaining, (String)"/");
        if (ns == null) {
            ns = remaining;
        }
        if (path == null) {
            path = remaining;
        }
        EtcdNamespace namespace = (EtcdNamespace)((Object)this.getCamelContext().getTypeConverter().mandatoryConvertTo(EtcdNamespace.class, (Object)ns));
        EtcdConfiguration configuration = this.loadConfiguration(parameters);
        if (namespace != null) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            switch (namespace) {
                case stats: {
                    return new EtcdStatsEndpoint(uri, this, configuration, namespace, path);
                }
                case watch: {
                    return new EtcdWatchEndpoint(uri, this, configuration, namespace, path);
                }
                case keys: {
                    return new EtcdKeysEndpoint(uri, this, configuration, namespace, path);
                }
            }
            throw new IllegalStateException("No endpoint for " + remaining);
        }
        throw new IllegalStateException("No endpoint for " + remaining);
    }

    protected EtcdConfiguration loadConfiguration(Map<String, Object> parameters) throws Exception {
        EtcdConfiguration configuration = Optional.ofNullable(this.configuration).orElseGet(EtcdConfiguration::new).copy();
        configuration.setCamelContext(this.getCamelContext());
        this.setProperties(configuration, parameters);
        if (configuration.getSslContextParameters() == null) {
            configuration.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return configuration;
    }
}

