/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd;

import mousio.etcd4j.EtcdClient;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.etcd.AbstractEtcdEndpoint;
import org.apache.camel.component.etcd.EtcdConfiguration;
import org.apache.camel.component.etcd.EtcdEndpoint;
import org.apache.camel.component.etcd.EtcdNamespace;
import org.apache.camel.support.DefaultConsumer;

public abstract class AbstractEtcdConsumer
extends DefaultConsumer {
    private final EtcdConfiguration configuration;
    private final EtcdNamespace namespace;
    private final String path;
    private EtcdClient client;

    protected AbstractEtcdConsumer(AbstractEtcdEndpoint endpoint, Processor processor, EtcdConfiguration configuration, EtcdNamespace namespace, String path) {
        super((Endpoint)endpoint, processor);
        this.configuration = configuration;
        this.namespace = namespace;
        this.path = path;
        this.client = null;
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        super.doStop();
    }

    protected EtcdClient getClient() throws Exception {
        if (this.client == null) {
            this.client = ((EtcdEndpoint)this.getEndpoint()).createClient();
        }
        return this.client;
    }

    public EtcdConfiguration getConfiguration() {
        return this.configuration;
    }

    public EtcdNamespace getNamespace() {
        return this.namespace;
    }

    public String getPath() {
        return this.path;
    }
}

