/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.io.InputStream;
import javax.mail.Message;
import javax.mail.Multipart;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.mail.MailConverters;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public class MailConvertersLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
        this.registerFallbackConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        this.addTypeConverter(registry, InputStream.class, Message.class, false, (type, exchange, value) -> MailConverters.toInputStream((Message)value));
        this.addTypeConverter(registry, InputStream.class, Multipart.class, false, (type, exchange, value) -> MailConverters.toInputStream((Multipart)value, exchange));
        this.addTypeConverter(registry, String.class, Message.class, false, (type, exchange, value) -> MailConverters.toString((Message)value));
        this.addTypeConverter(registry, String.class, Multipart.class, false, (type, exchange, value) -> MailConverters.toString((Multipart)value));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        this.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> MailConverters.convertTo(type, exchange, value, registry));
    }

    private void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) {
        registry.addFallbackTypeConverter((TypeConverter)new SimpleTypeConverter(allowNull, method), canPromote);
    }
}

