/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi.impl;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Converter;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.impl.converter.AnnotationTypeConverterLoader;
import org.apache.camel.impl.scan.AnnotatedWithPackageScanFilter;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
BundleTrackerCustomizer<Object> {
    public static final String META_INF_COMPONENT = "META-INF/services/org/apache/camel/component/";
    public static final String META_INF_LANGUAGE = "META-INF/services/org/apache/camel/language/";
    public static final String META_INF_LANGUAGE_RESOLVER = "META-INF/services/org/apache/camel/language/resolver/";
    public static final String META_INF_DATAFORMAT = "META-INF/services/org/apache/camel/dataformat/";
    public static final String META_INF_TYPE_CONVERTER = "META-INF/services/org/apache/camel/TypeConverter";
    public static final String META_INF_TYPE_CONVERTER_LOADER = "META-INF/services/org/apache/camel/TypeConverterLoader";
    public static final String META_INF_FALLBACK_TYPE_CONVERTER = "META-INF/services/org/apache/camel/FallbackTypeConverter";
    public static final String EXTENDER_NAMESPACE = "osgi.extender";
    public static final String CAMEL_EXTENDER = "org.apache.camel";
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private BundleTracker<?> tracker;
    private final Map<Long, List<BaseService>> resolvers = new ConcurrentHashMap<Long, List<BaseService>>();
    private long bundleId;
    private final Map<String, BundleCapability> packageCapabilities = new HashMap<String, BundleCapability>();

    public void start(BundleContext context) throws Exception {
        LOG.info("Camel activator starting");
        this.cachePackageCapabilities(context);
        this.bundleId = context.getBundle().getBundleId();
        BundleContext systemBundleContext = context.getBundle(0L).getBundleContext();
        this.tracker = new BundleTracker(systemBundleContext, 32, (BundleTrackerCustomizer)this);
        this.tracker.open();
        LOG.info("Camel activator started");
    }

    public void stop(BundleContext context) throws Exception {
        LOG.info("Camel activator stopping");
        this.tracker.close();
        this.packageCapabilities.clear();
        LOG.info("Camel activator stopped");
    }

    private void cachePackageCapabilities(BundleContext context) {
        BundleWiring ourWiring = (BundleWiring)context.getBundle().adapt(BundleWiring.class);
        List ourExports = ourWiring.getCapabilities("osgi.wiring.package");
        for (BundleCapability ourExport : ourExports) {
            String ourPkgName = (String)ourExport.getAttributes().get("osgi.wiring.package");
            this.packageCapabilities.put(ourPkgName, ourExport);
        }
        for (BundleWire w : ourWiring.getRequiredWires("osgi.wiring.package")) {
            BundleCapability cap = w.getCapability();
            String ourPkgName = (String)cap.getAttributes().get("osgi.wiring.package");
            this.packageCapabilities.put(ourPkgName, cap);
        }
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        LOG.debug("Bundle started: {}", (Object)bundle.getSymbolicName());
        if (this.extenderCapabilityWired(bundle)) {
            ArrayList<BaseService> r = new ArrayList<BaseService>();
            this.registerComponents(bundle, r);
            this.registerLanguages(bundle, r);
            this.registerDataFormats(bundle, r);
            this.registerTypeConverterLoader(bundle, r);
            for (BaseService service : r) {
                service.register();
            }
            this.resolvers.put(bundle.getBundleId(), r);
        }
        return bundle;
    }

    private boolean extenderCapabilityWired(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            return true;
        }
        List requiredWires = wiring.getRequiredWires(EXTENDER_NAMESPACE);
        for (BundleWire requiredWire : requiredWires) {
            if (!CAMEL_EXTENDER.equals(requiredWire.getCapability().getAttributes().get(EXTENDER_NAMESPACE))) continue;
            if (this.bundleId == requiredWire.getProviderWiring().getBundle().getBundleId()) {
                LOG.debug("Camel extender requirement of bundle {} correctly wired to this implementation", (Object)bundle.getBundleId());
                return true;
            }
            LOG.info("Not processing bundle {} as it requires a camel extender but is not wired to the this implementation", (Object)bundle.getBundleId());
            return false;
        }
        return true;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        LOG.debug("Bundle stopped: {}", (Object)bundle.getSymbolicName());
        List<BaseService> r = this.resolvers.remove(bundle.getBundleId());
        if (r != null) {
            for (BaseService service : r) {
                service.unregister();
            }
        }
    }

    protected void registerComponents(Bundle bundle, List<BaseService> resolvers) {
        if (this.canSee(bundle, Component.class)) {
            HashMap<String, String> components = new HashMap<String, String>();
            Enumeration e = bundle.getEntryPaths(META_INF_COMPONENT);
            while (e != null && e.hasMoreElements()) {
                String path = (String)e.nextElement();
                LOG.debug("Found entry: {} in bundle {}", (Object)path, (Object)bundle.getSymbolicName());
                String name = path.substring(path.lastIndexOf("/") + 1);
                components.put(name, path);
            }
            if (!components.isEmpty()) {
                resolvers.add(new BundleComponentResolver(bundle, components));
            }
        }
    }

    protected void registerLanguages(Bundle bundle, List<BaseService> resolvers) {
        if (this.canSee(bundle, Language.class)) {
            String name;
            String path;
            HashMap<String, String> languages = new HashMap<String, String>();
            Enumeration e = bundle.getEntryPaths(META_INF_LANGUAGE);
            while (e != null && e.hasMoreElements()) {
                path = (String)e.nextElement();
                LOG.debug("Found entry: {} in bundle {}", (Object)path, (Object)bundle.getSymbolicName());
                name = path.substring(path.lastIndexOf("/") + 1);
                languages.put(name, path);
            }
            if (!languages.isEmpty()) {
                resolvers.add(new BundleLanguageResolver(bundle, languages));
            }
            e = bundle.getEntryPaths(META_INF_LANGUAGE_RESOLVER);
            while (e != null && e.hasMoreElements()) {
                path = (String)e.nextElement();
                LOG.debug("Found entry: {} in bundle {}", (Object)path, (Object)bundle.getSymbolicName());
                name = path.substring(path.lastIndexOf("/") + 1);
                resolvers.add(new BundleMetaLanguageResolver(bundle, name, path));
            }
        }
    }

    protected void registerDataFormats(Bundle bundle, List<BaseService> resolvers) {
        if (this.canSee(bundle, DataFormat.class)) {
            HashMap<String, String> dataformats = new HashMap<String, String>();
            Enumeration e = bundle.getEntryPaths(META_INF_DATAFORMAT);
            while (e != null && e.hasMoreElements()) {
                String path = (String)e.nextElement();
                LOG.debug("Found entry: {} in bundle {}", (Object)path, (Object)bundle.getSymbolicName());
                String name = path.substring(path.lastIndexOf("/") + 1);
                dataformats.put(name, path);
            }
            if (!dataformats.isEmpty()) {
                resolvers.add(new BundleDataFormatResolver(bundle, dataformats));
            }
        }
    }

    protected void registerTypeConverterLoader(Bundle bundle, List<BaseService> resolvers) {
        if (this.canSee(bundle, TypeConverter.class)) {
            URL url1 = bundle.getEntry(META_INF_TYPE_CONVERTER);
            URL url2 = bundle.getEntry(META_INF_TYPE_CONVERTER_LOADER);
            URL url3 = bundle.getEntry(META_INF_FALLBACK_TYPE_CONVERTER);
            if (url1 != null || url2 != null || url3 != null) {
                LOG.debug("Found TypeConverter in bundle {}", (Object)bundle.getSymbolicName());
                resolvers.add(new BundleTypeConverterLoader(bundle, url3 != null));
            }
        }
    }

    protected boolean canSee(Bundle bundle, Class<?> clazz) {
        Bundle root;
        if (bundle.getBundleId() == this.bundleId) {
            return true;
        }
        BundleCapability packageCap = this.packageCapabilities.get(clazz.getPackage().getName());
        if (packageCap != null) {
            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            List imports = wiring.getRequiredWires("osgi.wiring.package");
            for (BundleWire importWire : imports) {
                if (!packageCap.equals(importWire.getCapability())) continue;
                return true;
            }
        }
        if (bundle.getBundleId() >= 0L && (root = bundle.getBundleContext().getBundle(0L)) != null && "org.apache.felix.connect".equals(root.getSymbolicName())) {
            return Activator.checkCompat(bundle, clazz);
        }
        return false;
    }

    protected static boolean checkCompat(Bundle bundle, Class<?> clazz) {
        try {
            if (bundle.loadClass(clazz.getName()) != clazz) {
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    protected static Properties loadProperties(URL url) {
        Properties properties = new Properties();
        BufferedInputStream reader = null;
        try {
            reader = IOHelper.buffered((InputStream)url.openStream());
            properties.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOHelper.close((Closeable)reader, (String)"properties", (Logger)LOG);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Set<String> getConverterPackages(URL resource) {
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        if (resource != null) {
            BufferedReader reader = null;
            try {
                String line;
                reader = IOHelper.buffered((Reader)new InputStreamReader(resource.openStream()));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                    StringTokenizer iter = new StringTokenizer(line, ",");
                    while (iter.hasMoreTokens()) {
                        String name = iter.nextToken().trim();
                        if (name.length() <= 0) continue;
                        packages.add(name);
                    }
                }
            }
            catch (Exception exception) {
                IOHelper.close(reader, null, (Logger)LOG);
            }
            catch (Throwable throwable) {
                IOHelper.close(reader, null, (Logger)LOG);
                throw throwable;
            }
            IOHelper.close((Closeable)reader, null, (Logger)LOG);
        }
        return packages;
    }

    protected static abstract class BaseService {
        protected final Bundle bundle;
        private ServiceRegistration<?> reg;

        protected BaseService(Bundle bundle) {
            this.bundle = bundle;
        }

        public abstract void register();

        protected void doRegister(Class<?> type, String key, Collection<String> value) {
            this.doRegister(type, key, value.toArray(new String[value.size()]));
        }

        protected void doRegister(Class<?> type, String key, Object value) {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put(key, value);
            this.doRegister(type, props);
        }

        protected void doRegister(Class<?> type) {
            this.doRegister(type, null);
        }

        protected void doRegister(Class<?> type, Dictionary<String, ?> props) {
            this.reg = this.bundle.getBundleContext().registerService(type.getName(), (Object)this, props);
        }

        public void unregister() {
            this.reg.unregister();
        }
    }

    protected static abstract class BaseResolver<T>
    extends BaseService {
        private final Class<T> type;

        public BaseResolver(Bundle bundle, Class<T> type) {
            super(bundle);
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected T createInstance(String name, String path, CamelContext context) {
            if (path == null) {
                return null;
            }
            URL url = this.bundle.getEntry(path);
            LOG.trace("The entry {}'s url is {}", (Object)name, (Object)url);
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                T answer;
                ClassLoader newClassLoader = context.getApplicationContextClassLoader();
                if (newClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(newClassLoader);
                }
                if ((answer = this.createInstance(name, url, context.getInjector())) != null) {
                    this.initBundleContext(answer);
                }
                T t = answer;
                return t;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }

        private void initBundleContext(T answer) {
            try {
                Method method = answer.getClass().getMethod("setBundleContext", BundleContext.class);
                if (method != null) {
                    method.invoke(answer, this.bundle.getBundleContext());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected T createInstance(String name, URL url, Injector injector) {
            try {
                Properties properties = Activator.loadProperties(url);
                String classname = (String)properties.get("class");
                Class type = this.bundle.loadClass(classname);
                if (!this.type.isAssignableFrom(type)) {
                    throw new IllegalArgumentException("Type is not a " + this.type.getName() + " implementation. Found: " + type.getName());
                }
                return (T)injector.newInstance(type, false);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Invalid URI, no " + this.type.getName() + " registered for scheme : " + name, e);
            }
        }
    }

    protected static class BundleTypeConverterLoader
    extends BaseResolver<TypeConverter>
    implements TypeConverterLoader {
        private final AnnotationTypeConverterLoader loader = new Loader();
        private final Bundle bundle;
        private final boolean hasFallbackTypeConverter;

        public BundleTypeConverterLoader(Bundle bundle, boolean hasFallbackTypeConverter) {
            super(bundle, TypeConverter.class);
            ObjectHelper.notNull((Object)bundle, (String)"bundle");
            this.bundle = bundle;
            this.hasFallbackTypeConverter = hasFallbackTypeConverter;
        }

        public synchronized void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
            try {
                this.loader.load(registry);
            }
            catch (Exception e) {
                throw new TypeConverterLoaderException("Cannot load type converters using OSGi bundle: " + this.bundle.getBundleId(), (Throwable)e);
            }
        }

        @Override
        public void register() {
            if (this.hasFallbackTypeConverter) {
                this.doRegister(TypeConverterLoader.class, "service.ranking", 100);
            } else {
                this.doRegister(TypeConverterLoader.class);
            }
        }

        class Loader
        extends AnnotationTypeConverterLoader {
            Loader() {
                super(null);
            }

            public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
                AnnotatedWithPackageScanFilter test = new AnnotatedWithPackageScanFilter(Converter.class, true);
                LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
                Set<String> packages = Activator.getConverterPackages(BundleTypeConverterLoader.this.bundle.getEntry(Activator.META_INF_TYPE_CONVERTER));
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Found {} {} packages: {}", new Object[]{packages.size(), Activator.META_INF_TYPE_CONVERTER, packages});
                }
                if (packages.size() == 1 && "org.apache.camel.core".equals(packages.iterator().next())) {
                    LOG.debug("No additional package names found in classpath for annotated type converters.");
                    return;
                }
                packages.remove("org.apache.camel.core");
                for (String pkg : packages) {
                    if (StringHelper.isClassName((String)pkg)) {
                        LOG.trace("Loading {} class", (Object)pkg);
                        try {
                            Class clazz = BundleTypeConverterLoader.this.bundle.loadClass(pkg);
                            classes.add(clazz);
                            continue;
                        }
                        catch (Throwable t) {
                            LOG.trace("Failed to load " + pkg + " class due " + t.getMessage() + ". This exception will be ignored.", t);
                        }
                    }
                    Enumeration e = BundleTypeConverterLoader.this.bundle.findEntries("/" + pkg.replace('.', '/'), "*.class", true);
                    while (e != null && e.hasMoreElements()) {
                        String path;
                        String externalName = path.substring((path = ((URL)e.nextElement()).getPath()).charAt(0) == '/' ? 1 : 0, path.indexOf(46)).replace('/', '.');
                        LOG.trace("Loading {} class", (Object)externalName);
                        try {
                            Class clazz = BundleTypeConverterLoader.this.bundle.loadClass(externalName);
                            if (!test.matches(clazz)) continue;
                            classes.add(clazz);
                        }
                        catch (Throwable t) {
                            LOG.trace("Failed to load " + externalName + " class due " + t.getMessage() + ". This exception will be ignored.", t);
                        }
                    }
                }
                LOG.debug("Found {} @Converter classes to load", (Object)classes.size());
                for (Class type : classes) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Loading converter class: {}", (Object)ObjectHelper.name((Class)type));
                    }
                    this.loadConverterMethods(registry, type);
                }
                URL fallbackUrl = BundleTypeConverterLoader.this.bundle.getEntry(Activator.META_INF_FALLBACK_TYPE_CONVERTER);
                if (fallbackUrl != null) {
                    LOG.debug("Found {} to load the FallbackTypeConverter", (Object)Activator.META_INF_FALLBACK_TYPE_CONVERTER);
                    TypeConverter tc = (TypeConverter)BundleTypeConverterLoader.this.createInstance("FallbackTypeConverter", fallbackUrl, registry.getInjector());
                    registry.addFallbackTypeConverter(tc, false);
                }
                this.visitedClasses.clear();
                this.visitedURIs.clear();
            }
        }
    }

    protected static class BundleDataFormatResolver
    extends BaseResolver<DataFormat>
    implements DataFormatResolver {
        private final Map<String, String> dataformats;

        public BundleDataFormatResolver(Bundle bundle, Map<String, String> dataformats) {
            super(bundle, DataFormat.class);
            this.dataformats = dataformats;
        }

        public DataFormat resolveDataFormat(String name, CamelContext context) {
            DataFormat dataFormat = (DataFormat)this.createInstance(name, this.dataformats.get(name), context);
            if (dataFormat == null) {
                dataFormat = this.createDataFormat(name, context);
            }
            return dataFormat;
        }

        public DataFormat createDataFormat(String name, CamelContext context) {
            return (DataFormat)this.createInstance(name, this.dataformats.get(name), context);
        }

        public DataFormatDefinition resolveDataFormatDefinition(String name, CamelContext context) {
            return null;
        }

        @Override
        public void register() {
            this.doRegister(DataFormatResolver.class, "dataformat", this.dataformats.keySet());
        }
    }

    protected static class BundleMetaLanguageResolver
    extends BaseResolver<LanguageResolver>
    implements LanguageResolver {
        private final String name;
        private final String path;

        public BundleMetaLanguageResolver(Bundle bundle, String name, String path) {
            super(bundle, LanguageResolver.class);
            this.name = name;
            this.path = path;
        }

        public Language resolveLanguage(String name, CamelContext context) {
            LanguageResolver resolver = (LanguageResolver)this.createInstance(this.name, this.path, context);
            return resolver.resolveLanguage(name, context);
        }

        @Override
        public void register() {
            this.doRegister(LanguageResolver.class, "resolver", this.name);
        }
    }

    protected static class BundleLanguageResolver
    extends BaseResolver<Language>
    implements LanguageResolver {
        private final Map<String, String> languages;

        public BundleLanguageResolver(Bundle bundle, Map<String, String> languages) {
            super(bundle, Language.class);
            this.languages = languages;
        }

        public Language resolveLanguage(String name, CamelContext context) {
            return (Language)this.createInstance(name, this.languages.get(name), context);
        }

        @Override
        public void register() {
            this.doRegister(LanguageResolver.class, "language", this.languages.keySet());
        }
    }

    protected static class BundleComponentResolver
    extends BaseResolver<Component>
    implements ComponentResolver {
        private final Map<String, String> components;

        public BundleComponentResolver(Bundle bundle, Map<String, String> components) {
            super(bundle, Component.class);
            this.components = components;
        }

        public Component resolveComponent(String name, CamelContext context) throws Exception {
            return (Component)this.createInstance(name, this.components.get(name), context);
        }

        @Override
        public void register() {
            this.doRegister(ComponentResolver.class, "component", this.components.keySet());
        }
    }
}

