/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcr;

import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Value;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.jcr.JcrConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public class JcrConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        this.addTypeConverter(registry, InputStream.class, Value.class, false, (type, exchange, value) -> JcrConverter.toValue((Value)value));
        this.addTypeConverter(registry, Boolean.class, Value.class, false, (type, exchange, value) -> JcrConverter.toBoolean((Value)value));
        this.addTypeConverter(registry, String.class, Value.class, false, (type, exchange, value) -> JcrConverter.toString((Value)value));
        this.addTypeConverter(registry, Calendar.class, Value.class, false, (type, exchange, value) -> JcrConverter.toCalendar((Value)value));
        this.addTypeConverter(registry, Value.class, InputStream.class, false, (type, exchange, value) -> JcrConverter.toValue((InputStream)value));
        this.addTypeConverter(registry, Value.class, Boolean.class, false, (type, exchange, value) -> JcrConverter.toValue((Boolean)value));
        this.addTypeConverter(registry, Value.class, String.class, false, (type, exchange, value) -> JcrConverter.toValue((String)value));
        this.addTypeConverter(registry, Value.class, Calendar.class, false, (type, exchange, value) -> JcrConverter.toValue((Calendar)value));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

