/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.rss;

import com.sun.syndication.feed.synd.SyndFeed;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.rss.RssConverter;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceSupport;

@Dataformat(value="rss")
public class RssDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    public String getDataFormatName() {
        return "rss";
    }

    public void marshal(Exchange exchange, Object body, OutputStream out) throws Exception {
        SyndFeed feed = (SyndFeed)ExchangeHelper.convertToMandatoryType((Exchange)exchange, SyndFeed.class, (Object)body);
        String xml = RssConverter.feedToXml(feed);
        out.write(xml.getBytes());
    }

    public Object unmarshal(Exchange exchange, InputStream in) throws Exception {
        String xml = (String)ExchangeHelper.convertToMandatoryType((Exchange)exchange, String.class, (Object)in);
        return RssConverter.xmlToFeed(xml);
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

