/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine.lrucache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import org.apache.camel.support.LRUCache;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineLRUCache<K, V>
implements LRUCache<K, V>,
RemovalListener<K, V>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(CaffeineLRUCache.class);
    protected final LongAdder hits = new LongAdder();
    protected final LongAdder misses = new LongAdder();
    protected final LongAdder evicted = new LongAdder();
    private int maxCacheSize = 10000;
    private final Cache<K, V> cache;
    private final Map<K, V> map;
    private final Consumer<V> evict;

    public CaffeineLRUCache(int maximumCacheSize) {
        this(16, maximumCacheSize);
    }

    public CaffeineLRUCache(int initialCapacity, int maximumCacheSize) {
        this(initialCapacity, maximumCacheSize, maximumCacheSize > 0);
    }

    public CaffeineLRUCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        this(initialCapacity, maximumCacheSize, stopOnEviction, false, false, false);
    }

    public CaffeineLRUCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction, boolean soft, boolean weak, boolean syncListener) {
        this(initialCapacity, maximumCacheSize, stopOnEviction ? CaffeineLRUCache::doStop : CaffeineLRUCache::doNothing, soft, weak, syncListener);
    }

    public CaffeineLRUCache(int initialCapacity, int maximumCacheSize, Consumer<V> evict, boolean soft, boolean weak, boolean syncListener) {
        Caffeine caffeine = Caffeine.newBuilder().initialCapacity(initialCapacity).maximumSize((long)maximumCacheSize).removalListener((RemovalListener)this);
        if (soft) {
            caffeine.softValues();
        }
        if (weak) {
            caffeine.weakKeys();
            caffeine.weakValues();
        }
        if (syncListener) {
            caffeine.executor(Runnable::run);
        }
        this.cache = caffeine.build();
        this.map = this.cache.asMap();
        this.maxCacheSize = maximumCacheSize;
        this.evict = Objects.requireNonNull(evict);
    }

    public V get(Object o) {
        V answer = this.map.get(o);
        if (answer != null) {
            this.hits.increment();
        } else {
            this.misses.increment();
        }
        return answer;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object o) {
        return this.map.containsKey(o);
    }

    public boolean containsValue(Object o) {
        return this.map.containsValue(0);
    }

    public V put(K k, V v) {
        return this.map.put(k, v);
    }

    public V remove(Object o) {
        return this.map.remove(o);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.cache.putAll(map);
    }

    public void clear() {
        this.map.clear();
        this.resetStatistics();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Collection<V> values() {
        return this.map.values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    public void onRemoval(K key, V value, RemovalCause cause) {
        if (cause.wasEvicted()) {
            this.evicted.increment();
            LOG.trace("onRemoval {} -> {}", key, value);
            this.evict.accept(value);
        }
    }

    public long getHits() {
        return this.hits.longValue();
    }

    public long getMisses() {
        return this.misses.longValue();
    }

    public long getEvicted() {
        return this.evicted.longValue();
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void resetStatistics() {
        this.hits.reset();
        this.misses.reset();
        this.evicted.reset();
    }

    public void cleanUp() {
        this.cache.cleanUp();
    }

    public String toString() {
        return "CaffeineLRUCache@" + ObjectHelper.getIdentityHashCode((Object)this);
    }

    static <V> void doNothing(V value) {
    }

    static <V> void doStop(V value) {
        try {
            ServiceHelper.stopService(value);
        }
        catch (Exception e) {
            LOG.warn("Error stopping service: " + value + ". This exception will be ignored.", (Throwable)e);
        }
    }
}

