/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.internal;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.fhir.api.FhirHistory;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public enum FhirHistoryApiMethod implements ApiMethod
{
    ONINSTANCE(IBaseBundle.class, "onInstance", ApiMethodArg.arg((String)"id", IIdType.class), ApiMethodArg.arg((String)"returnType", Class.class), ApiMethodArg.arg((String)"count", Integer.class), ApiMethodArg.arg((String)"cutoff", Date.class), ApiMethodArg.arg((String)"iCutoff", IPrimitiveType.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    ONSERVER(IBaseBundle.class, "onServer", ApiMethodArg.arg((String)"returnType", Class.class), ApiMethodArg.arg((String)"count", Integer.class), ApiMethodArg.arg((String)"cutoff", Date.class), ApiMethodArg.arg((String)"iCutoff", IPrimitiveType.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    ONTYPE(IBaseBundle.class, "onType", ApiMethodArg.arg((String)"resourceType", Class.class), ApiMethodArg.arg((String)"returnType", Class.class), ApiMethodArg.arg((String)"count", Integer.class), ApiMethodArg.arg((String)"cutoff", Date.class), ApiMethodArg.arg((String)"iCutoff", IPrimitiveType.class), ApiMethodArg.arg((String)"extraParameters", Map.class));

    private final ApiMethod apiMethod;

    private FhirHistoryApiMethod(Class<?> resultType, String name, ApiMethodArg ... args) {
        this.apiMethod = new ApiMethodImpl(FhirHistory.class, resultType, name, args);
    }

    public String getName() {
        return this.apiMethod.getName();
    }

    public Class<?> getResultType() {
        return this.apiMethod.getResultType();
    }

    public List<String> getArgNames() {
        return this.apiMethod.getArgNames();
    }

    public List<Class<?>> getArgTypes() {
        return this.apiMethod.getArgTypes();
    }

    public Method getMethod() {
        return this.apiMethod.getMethod();
    }
}

