/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.internal;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.PerformanceOptionsEnum;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.client.apache.GZipContentInterceptor;
import ca.uhn.fhir.rest.client.api.IClientInterceptor;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.IRestfulClientFactory;
import ca.uhn.fhir.rest.client.api.ServerValidationModeEnum;
import ca.uhn.fhir.rest.client.interceptor.BasicAuthInterceptor;
import ca.uhn.fhir.rest.client.interceptor.BearerTokenAuthInterceptor;
import ca.uhn.fhir.rest.client.interceptor.CookieInterceptor;
import ca.uhn.fhir.rest.client.interceptor.LoggingInterceptor;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.fhir.FhirConfiguration;
import org.apache.camel.util.ObjectHelper;

public final class FhirHelper {
    private FhirHelper() {
    }

    public static IGenericClient createClient(FhirConfiguration endpointConfiguration, CamelContext camelContext) {
        if (endpointConfiguration.getClient() != null) {
            return endpointConfiguration.getClient();
        }
        FhirContext fhirContext = FhirHelper.getFhirContext(endpointConfiguration);
        if (endpointConfiguration.isDeferModelScanning()) {
            fhirContext.setPerformanceOptions(new PerformanceOptionsEnum[]{PerformanceOptionsEnum.DEFERRED_MODEL_SCANNING});
        }
        if (endpointConfiguration.getClientFactory() != null) {
            fhirContext.setRestfulClientFactory(endpointConfiguration.getClientFactory());
        }
        IRestfulClientFactory restfulClientFactory = fhirContext.getRestfulClientFactory();
        FhirHelper.configureClientFactory(endpointConfiguration, restfulClientFactory, camelContext);
        IGenericClient genericClient = fhirContext.newRestfulGenericClient(endpointConfiguration.getServerUrl());
        genericClient.setPrettyPrint(Boolean.valueOf(endpointConfiguration.isPrettyPrint()));
        EncodingEnum encoding = endpointConfiguration.getEncoding();
        SummaryEnum summary = endpointConfiguration.getSummary();
        if (encoding != null) {
            genericClient.setEncoding(encoding);
        }
        if (summary != null) {
            genericClient.setSummary(summary);
        }
        if (endpointConfiguration.isForceConformanceCheck()) {
            genericClient.forceConformanceCheck();
        }
        FhirHelper.registerClientInterceptors(genericClient, endpointConfiguration);
        return genericClient;
    }

    private static void configureClientFactory(FhirConfiguration endpointConfiguration, IRestfulClientFactory restfulClientFactory, CamelContext camelContext) {
        Integer connectionTimeout = endpointConfiguration.getConnectionTimeout();
        Integer socketTimeout = endpointConfiguration.getSocketTimeout();
        if (ObjectHelper.isNotEmpty((Object)connectionTimeout)) {
            restfulClientFactory.setConnectTimeout(connectionTimeout.intValue());
        }
        if (ObjectHelper.isNotEmpty((Object)socketTimeout)) {
            restfulClientFactory.setSocketTimeout(socketTimeout.intValue());
        }
        FhirHelper.configureProxy(endpointConfiguration, restfulClientFactory, camelContext);
    }

    private static void configureProxy(FhirConfiguration endpointConfiguration, IRestfulClientFactory restfulClientFactory, CamelContext camelContext) {
        ServerValidationModeEnum validationMode = endpointConfiguration.getValidationMode();
        String proxyHost = endpointConfiguration.getProxyHost();
        Integer proxyPort = endpointConfiguration.getProxyPort();
        String proxyUser = endpointConfiguration.getProxyUser();
        String proxyPassword = endpointConfiguration.getProxyPassword();
        String camelProxyHost = camelContext.getGlobalOption("http.proxyHost");
        String camelProxyPort = camelContext.getGlobalOption("http.proxyPort");
        if (ObjectHelper.isNotEmpty((Object)camelProxyHost) && ObjectHelper.isNotEmpty((Object)camelProxyPort)) {
            restfulClientFactory.setProxy(camelProxyHost, Integer.valueOf(Integer.parseInt(camelProxyPort)));
        }
        if (ObjectHelper.isNotEmpty((Object)proxyHost) && ObjectHelper.isNotEmpty((Object)proxyPort)) {
            restfulClientFactory.setProxy(proxyHost, proxyPort);
        }
        if (ObjectHelper.isNotEmpty((Object)proxyUser)) {
            restfulClientFactory.setProxyCredentials(proxyUser, proxyPassword);
        }
        if (ObjectHelper.isNotEmpty((Object)validationMode)) {
            restfulClientFactory.setServerValidationMode(validationMode);
        }
    }

    private static void registerClientInterceptors(IGenericClient genericClient, FhirConfiguration endpointConfiguration) {
        String username = endpointConfiguration.getUsername();
        String password = endpointConfiguration.getPassword();
        String accessToken = endpointConfiguration.getAccessToken();
        String sessionCookie = endpointConfiguration.getSessionCookie();
        if (ObjectHelper.isNotEmpty((Object)username)) {
            genericClient.registerInterceptor((IClientInterceptor)new BasicAuthInterceptor(username, password));
        }
        if (ObjectHelper.isNotEmpty((Object)accessToken)) {
            genericClient.registerInterceptor((IClientInterceptor)new BearerTokenAuthInterceptor(accessToken));
        }
        if (endpointConfiguration.isLog()) {
            genericClient.registerInterceptor((IClientInterceptor)new LoggingInterceptor(true));
        }
        if (endpointConfiguration.isCompress()) {
            genericClient.registerInterceptor((IClientInterceptor)new GZipContentInterceptor());
        }
        if (ObjectHelper.isNotEmpty((Object)sessionCookie)) {
            genericClient.registerInterceptor((IClientInterceptor)new CookieInterceptor(sessionCookie));
        }
    }

    private static FhirContext getFhirContext(FhirConfiguration endpointConfiguration) {
        FhirContext context = endpointConfiguration.getFhirContext();
        if (context != null) {
            return context;
        }
        if (ObjectHelper.isEmpty((Object)endpointConfiguration.getServerUrl())) {
            throw new RuntimeCamelException("The FHIR URL must be set!");
        }
        FhirVersionEnum fhirVersion = endpointConfiguration.getFhirVersion();
        return new FhirContext(fhirVersion);
    }
}

