/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flink;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.flink.DataSetCallback;
import org.apache.camel.component.flink.DataSetFlinkProducer;
import org.apache.camel.component.flink.DataStreamCallback;
import org.apache.camel.component.flink.DataStreamFlinkProducer;
import org.apache.camel.component.flink.EndpointType;
import org.apache.camel.component.flink.FlinkComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.streaming.api.datastream.DataStream;

@UriEndpoint(firstVersion="2.18.0", scheme="flink", title="Apache Flink", syntax="flink:endpointType", producerOnly=true, label="hadoop")
public class FlinkEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true)
    private EndpointType endpointType;
    @UriParam
    private DataSet dataSet;
    @UriParam
    private DataSetCallback dataSetCallback;
    @UriParam
    private DataStream dataStream;
    @UriParam
    private DataStreamCallback dataStreamCallback;
    @UriParam(defaultValue="true")
    private boolean collect = true;

    public FlinkEndpoint(String endpointUri, FlinkComponent component, EndpointType endpointType) {
        super(endpointUri, (Component)component);
        this.endpointType = endpointType;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.dataSet == null) {
            this.dataSet = this.getComponent().getDataSet();
        }
        if (this.dataSetCallback == null) {
            this.dataSetCallback = this.getComponent().getDataSetCallback();
        }
    }

    public Producer createProducer() throws Exception {
        if (this.endpointType == EndpointType.dataset) {
            return new DataSetFlinkProducer(this);
        }
        if (this.endpointType == EndpointType.datastream) {
            return new DataStreamFlinkProducer(this);
        }
        return null;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Flink Component supports producer endpoints only.");
    }

    public FlinkComponent getComponent() {
        return (FlinkComponent)super.getComponent();
    }

    public void setEndpointType(EndpointType endpointType) {
        this.endpointType = endpointType;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public DataStream getDataStream() {
        return this.dataStream;
    }

    public void setDataSet(DataSet ds) {
        this.dataSet = ds;
    }

    public void setDataStream(DataStream ds) {
        this.dataStream = ds;
    }

    public DataSetCallback getDataSetCallback() {
        return this.dataSetCallback;
    }

    public DataStreamCallback getDataStreamCallback() {
        return this.dataStreamCallback;
    }

    public void setDataSetCallback(DataSetCallback dataSetCallback) {
        this.dataSetCallback = dataSetCallback;
    }

    public void setDataStreamCallback(DataStreamCallback dataStreamCallback) {
        this.dataStreamCallback = dataStreamCallback;
    }

    public boolean isCollect() {
        return this.collect;
    }

    public void setCollect(boolean collect) {
        this.collect = collect;
    }
}

