/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.paho;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.paho.PahoEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class PahoProducer
extends DefaultProducer {
    public PahoProducer(PahoEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        MqttClient client = this.getEndpoint().getClient();
        String topic = (String)exchange.getIn().getHeader("CamelPahoOverrideTopic", (Object)this.getEndpoint().getTopic(), String.class);
        int qos = (Integer)exchange.getIn().getHeader("CamelPahoQos", (Object)this.getEndpoint().getQos(), Integer.class);
        boolean retained = (Boolean)exchange.getIn().getHeader("CamelPahoRetained", (Object)this.getEndpoint().isRetained(), Boolean.class);
        byte[] payload = (byte[])exchange.getIn().getBody(byte[].class);
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        this.log.debug("Publishing to topic: {}, qos: {}, retrained: {}", new Object[]{topic, qos, retained});
        client.publish(topic, message);
    }

    public PahoEndpoint getEndpoint() {
        return (PahoEndpoint)super.getEndpoint();
    }
}

