/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cm;

import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.cm.CMConfiguration;
import org.apache.camel.component.cm.CMEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="cm-sms")
public class CMComponent
extends DefaultComponent {
    private Validator validator;

    public CMComponent() {
    }

    public CMComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CMConfiguration config = new CMConfiguration();
        this.setProperties(config, parameters);
        this.log.debug("Validating uri based configuration");
        Set constraintViolations = this.getValidator().validate((Object)config, new Class[0]);
        if (constraintViolations.size() > 0) {
            StringBuffer msg = new StringBuffer();
            for (ConstraintViolation cv : constraintViolations) {
                msg.append(String.format("- Invalid value for %s: %s", cv.getPropertyPath().toString(), cv.getMessage()));
            }
            throw new ResolveEndpointFailedException(uri, msg.toString());
        }
        CMEndpoint endpoint = new CMEndpoint(uri, this);
        endpoint.setConfiguration(config);
        endpoint.setHost(remaining);
        return endpoint;
    }

    public Validator getValidator() {
        if (this.validator == null) {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            this.validator = factory.getValidator();
        }
        return this.validator;
    }
}

