/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.activemq.converter;

import javax.jms.MessageListener;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.activemq.converter.ActiveMQMessageConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public class ActiveMQMessageConverterLoader
implements TypeConverterLoader {
    private volatile ActiveMQMessageConverter activeMQMessageConverter;

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        this.addTypeConverter(registry, ActiveMQMessage.class, Exchange.class, false, (type, exchange, value) -> this.getActiveMQMessageConverter().toMessage((Exchange)value));
        this.addTypeConverter(registry, Processor.class, MessageListener.class, false, (type, exchange, value) -> this.getActiveMQMessageConverter().toProcessor((MessageListener)value));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActiveMQMessageConverter getActiveMQMessageConverter() {
        if (this.activeMQMessageConverter == null) {
            ActiveMQMessageConverterLoader activeMQMessageConverterLoader = this;
            synchronized (activeMQMessageConverterLoader) {
                if (this.activeMQMessageConverter == null) {
                    this.activeMQMessageConverter = new ActiveMQMessageConverter();
                }
            }
        }
        return this.activeMQMessageConverter;
    }
}

