/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.activemq.converter;

import org.apache.activemq.command.ActiveMQDestination;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.activemq.converter.ActiveMQConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public class ActiveMQConverterLoader
implements TypeConverterLoader {
    private volatile ActiveMQConverter activeMQConverter;

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        this.addTypeConverter(registry, ActiveMQDestination.class, String.class, false, (type, exchange, value) -> this.getActiveMQConverter().toDestination((String)value));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActiveMQConverter getActiveMQConverter() {
        if (this.activeMQConverter == null) {
            ActiveMQConverterLoader activeMQConverterLoader = this;
            synchronized (activeMQConverterLoader) {
                if (this.activeMQConverter == null) {
                    this.activeMQConverter = new ActiveMQConverter();
                }
            }
        }
        return this.activeMQConverter;
    }
}

