/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.activemq;

import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQMessageProducerSupport;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Producer;
import org.apache.camel.component.activemq.CamelDestination;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.util.ObjectHelper;

public class CamelMessageProducer
extends ActiveMQMessageProducerSupport {
    protected Producer producer;
    private final CamelDestination destination;
    private final Endpoint endpoint;
    private boolean closed;

    public CamelMessageProducer(CamelDestination destination, Endpoint endpoint, ActiveMQSession session) throws JMSException {
        super(session);
        this.destination = destination;
        this.endpoint = endpoint;
        try {
            this.producer = endpoint.createProducer();
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create((Exception)e);
        }
    }

    public CamelDestination getDestination() throws JMSException {
        return this.destination;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void close() throws JMSException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.producer.stop();
            }
            catch (Exception e) {
                throw JMSExceptionSupport.create((Exception)e);
            }
        }
    }

    public void send(Destination destination, javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        CamelDestination camelDestination = null;
        if (!ObjectHelper.equal((Object)destination, (Object)this.destination)) {
            throw new IllegalArgumentException("Invalid destination setting: " + destination + " when expected: " + this.destination);
        }
        camelDestination = this.destination;
        try {
            Exchange exchange = this.endpoint.createExchange(ExchangePattern.InOnly);
            exchange.setIn((Message)new JmsMessage(exchange, message, null, camelDestination.getBinding()));
            this.producer.process(exchange);
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create((Exception)e);
        }
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The producer is closed");
        }
    }
}

