/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.nova.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.component.openstack.nova.NovaEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.compute.Action;
import org.openstack4j.model.compute.Server;
import org.openstack4j.model.compute.ServerCreate;
import org.openstack4j.model.compute.builder.ServerCreateBuilder;

public class ServerProducer
extends AbstractOpenstackProducer {
    public ServerProducer(NovaEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "createSnapshot": {
                this.doCreateSnapshot(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            case "action": {
                this.doAction(exchange);
                break;
            }
            default: {
                if (exchange.getIn().getHeaders().containsKey("action")) {
                    this.doAction(exchange);
                    break;
                }
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        ServerCreate in = this.messageToServer(exchange.getIn());
        Server out = this.os.compute().servers().boot(in);
        exchange.getIn().setBody((Object)out);
    }

    private void doCreateSnapshot(Exchange exchange) {
        Message msg = exchange.getIn();
        String serverId = (String)msg.getHeader("ID", String.class);
        String name = (String)msg.getHeader("name", String.class);
        StringHelper.notEmpty((String)serverId, (String)"Server ID");
        StringHelper.notEmpty((String)name, (String)"VolumeSnapshot name");
        String snapshotId = this.os.compute().servers().createSnapshot(serverId, name);
        msg.setBody((Object)snapshotId);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String serverId = (String)msg.getHeader("ID", String.class);
        StringHelper.notEmpty((String)serverId, (String)"Server ID");
        Server result = this.os.compute().servers().get(serverId);
        msg.setBody((Object)result);
    }

    private void doGetAll(Exchange exchange) {
        List out = this.os.compute().servers().list();
        exchange.getIn().setBody((Object)out);
    }

    private void doAction(Exchange exchange) {
        Message msg = exchange.getIn();
        Action action = (Action)msg.getHeader("action", Action.class);
        String serverId = (String)msg.getHeader("ID", String.class);
        ObjectHelper.notNull((Object)action, (String)"Server action");
        StringHelper.notEmpty((String)serverId, (String)"Server ID");
        ActionResponse response = this.os.compute().servers().action(serverId, action);
        this.checkFailure(response, msg, "Performing action " + action.name());
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String serverId = (String)msg.getHeader("ID", String.class);
        StringHelper.notEmpty((String)serverId, (String)"Server ID");
        ActionResponse response = this.os.compute().servers().delete(serverId);
        this.checkFailure(response, msg, "Delete server with ID " + serverId);
    }

    private ServerCreate messageToServer(Message message) {
        ServerCreate serverCreate = (ServerCreate)message.getBody(ServerCreate.class);
        if (serverCreate == null) {
            Map headers = message.getHeaders();
            ServerCreateBuilder builder = Builders.server();
            StringHelper.notEmpty((String)((String)message.getHeader("name", String.class)), (String)"Name");
            builder.name((String)message.getHeader("name", String.class));
            if (headers.containsKey("ImageId")) {
                builder.image((String)message.getHeader("ImageId", String.class));
            }
            if (headers.containsKey("NetworkId")) {
                builder.networks((List)message.getHeader("NetworkId", List.class));
            }
            if (headers.containsKey("FlavorId")) {
                builder.flavor((String)message.getHeader("FlavorId", String.class));
            }
            if (headers.containsKey("KeypairName")) {
                builder.keypairName((String)message.getHeader("KeypairName", String.class));
            }
            if (headers.containsKey("AdminPassword")) {
                builder.addAdminPass((String)message.getHeader("AdminPassword", String.class));
            }
            serverCreate = (ServerCreate)builder.build();
        }
        return serverCreate;
    }
}

