/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.swagger;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.rest.swagger.RestSwaggerEndpoint;
import org.apache.camel.component.rest.swagger.RestSwaggerHelper;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

@Component(value="rest-swagger")
public final class RestSwaggerComponent
extends DefaultComponent
implements SSLContextParametersAware {
    public static final String DEFAULT_BASE_PATH = "/";
    static final URI DEFAULT_SPECIFICATION_URI = URI.create("swagger.json");
    static final String DEFAULT_SPECIFICATION_URI_STR = "swagger.json";
    @Metadata(description="API basePath, for example \"`/v2`\". Default is unset, if set overrides the value present in Swagger specification.", defaultValue="", label="producer", required=false)
    private String basePath = "";
    @Metadata(description="Name of the Camel component that will perform the requests. The component must be present in Camel registry and it must implement RestProducerFactory service provider interface. If not set CLASSPATH is searched for single component that implements RestProducerFactory SPI. Can be overridden in endpoint configuration.", label="producer", required=false)
    private String componentName;
    @Metadata(description="What payload type this component capable of consuming. Could be one type, like `application/json` or multiple types as `application/json, application/xml; q=0.5` according to the RFC7231. This equates to the value of `Accept` HTTP header. If set overrides any value found in the Swagger specification. Can be overridden in endpoint configuration", label="producer", required=false)
    private String consumes;
    @Metadata(description="Scheme hostname and port to direct the HTTP requests to in the form of `http[s]://hostname[:port]`. Can be configured at the endpoint, component or in the correspoding REST configuration in the Camel Context. If you give this component a name (e.g. `petstore`) that REST configuration is consulted first, `rest-swagger` next, and global configuration last. If set overrides any value found in the Swagger specification, RestConfiguration. Can be overridden in endpoint configuration.", label="producer", required=false)
    private String host;
    @Metadata(description="What payload type this component is producing. For example `application/json` according to the RFC7231. This equates to the value of `Content-Type` HTTP header. If set overrides any value present in the Swagger specification. Can be overridden in endpoint configuration.", label="producer", required=false)
    private String produces;
    @Metadata(description="Path to the Swagger specification file. The scheme, host base path are taken from this specification, but these can be overriden with properties on the component or endpoint level. If not given the component tries to load `swagger.json` resource. Note that the `host` defined on the component and endpoint of this Component should contain the scheme, hostname and optionally the port in the URI syntax (i.e. `https://api.example.com:8080`). Can be overridden in endpoint configuration.", defaultValue="swagger.json", label="producer", required=false)
    private URI specificationUri;
    @Metadata(description="Customize TLS parameters used by the component. If not set defaults to the TLS parameters set in the Camel context ", label="security", required=false)
    private SSLContextParameters sslContextParameters;
    @Metadata(description="Enable usage of global SSL context parameters.", label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public RestSwaggerComponent() {
    }

    public RestSwaggerComponent(CamelContext context) {
        super(context);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getConsumes() {
        return this.consumes;
    }

    public String getHost() {
        return this.host;
    }

    public String getProduces() {
        return this.produces;
    }

    public URI getSpecificationUri() {
        return this.specificationUri;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setBasePath(String basePath) {
        this.basePath = StringHelper.notEmpty((String)basePath, (String)"basePath");
    }

    public void setComponentName(String componentName) {
        this.componentName = StringHelper.notEmpty((String)componentName, (String)"componentName");
    }

    public void setConsumes(String consumes) {
        this.consumes = RestSwaggerHelper.isMediaRange(consumes, "consumes");
    }

    public void setHost(String host) {
        this.host = RestSwaggerHelper.isHostParam(host);
    }

    public void setProduces(String produces) {
        this.produces = RestSwaggerHelper.isMediaRange(produces, "produces");
    }

    public void setSpecificationUri(URI specificationUri) {
        this.specificationUri = (URI)ObjectHelper.notNull((Object)specificationUri, (String)"specificationUri");
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        RestSwaggerEndpoint endpoint = new RestSwaggerEndpoint(uri, remaining, this, parameters);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }
}

