/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.policy;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Exchange;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.component.zookeeper.policy.ElectionWatcher;
import org.apache.camel.component.zookeeper.policy.ZooKeeperElection;
import org.apache.camel.support.RoutePolicySupport;

public class ZooKeeperRoutePolicy
extends RoutePolicySupport
implements ElectionWatcher,
NonManagedService {
    private final String uri;
    private final int enabledCount;
    private final Lock lock = new ReentrantLock();
    private final Set<Route> suspendedRoutes = new CopyOnWriteArraySet<Route>();
    private final AtomicBoolean shouldProcessExchanges = new AtomicBoolean();
    private volatile boolean shouldStopConsumer = true;
    private final Lock electionLock = new ReentrantLock();
    private ZooKeeperElection election;

    public ZooKeeperRoutePolicy(String uri, int enabledCount) {
        this.uri = uri;
        this.enabledCount = enabledCount;
    }

    public ZooKeeperRoutePolicy(ZooKeeperElection election) {
        this.election = election;
        this.uri = null;
        this.enabledCount = -1;
    }

    public void onExchangeBegin(Route route, Exchange exchange) {
        this.ensureElectionIsCreated(route);
        if (this.election.isMaster()) {
            if (this.shouldStopConsumer) {
                this.startConsumer(route);
            }
        } else {
            if (this.shouldStopConsumer) {
                this.stopConsumer(route);
            }
            IllegalStateException e = new IllegalStateException("Zookeeper based route policy prohibits processing exchanges, stopping route and failing the exchange");
            exchange.setException((Throwable)e);
        }
    }

    private void ensureElectionIsCreated(Route route) {
        if (this.election == null) {
            this.electionLock.lock();
            try {
                if (this.election == null) {
                    this.election = new ZooKeeperElection(route.getCamelContext(), this.uri, this.enabledCount);
                    this.election.addElectionWatcher(this);
                }
            }
            finally {
                this.electionLock.unlock();
            }
        }
    }

    private void startConsumer(Route route) {
        try {
            this.lock.lock();
            if (this.suspendedRoutes.contains(route)) {
                this.startConsumer(route.getConsumer());
                this.suspendedRoutes.remove(route);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void stopConsumer(Route route) {
        try {
            this.lock.lock();
            if (!this.suspendedRoutes.contains(route) && !this.shouldProcessExchanges.get()) {
                this.stopConsumer(route.getConsumer());
                this.suspendedRoutes.add(route);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void electionResultChanged() {
        if (this.election.isMaster()) {
            this.startAllStoppedConsumers();
        }
    }

    private void startAllStoppedConsumers() {
        try {
            this.lock.lock();
            if (!this.suspendedRoutes.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("{} have been stopped previously by policy, restarting.", (Object)this.suspendedRoutes.size());
                }
                for (Route suspended : this.suspendedRoutes) {
                    this.startConsumer(suspended.getConsumer());
                }
                this.suspendedRoutes.clear();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isShouldStopConsumer() {
        return this.shouldStopConsumer;
    }

    public void setShouldStopConsumer(boolean shouldStopConsumer) {
        this.shouldStopConsumer = shouldStopConsumer;
    }
}

