/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.policy;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.CamelContext;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.component.zookeeper.policy.CuratorMultiMasterLeaderElection;
import org.apache.camel.component.zookeeper.policy.ElectionWatcher;
import org.apache.camel.support.RoutePolicySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorMultiMasterLeaderRoutePolicy
extends RoutePolicySupport
implements ElectionWatcher,
NonManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(CuratorMultiMasterLeaderRoutePolicy.class);
    private final String uri;
    private final Lock lock = new ReentrantLock();
    private final Set<Route> suspendedRoutes = new CopyOnWriteArraySet<Route>();
    private final AtomicBoolean shouldProcessExchanges = new AtomicBoolean();
    private volatile boolean shouldStopRoute = true;
    private final int enabledCount;
    private final Lock electionLock = new ReentrantLock();
    private CuratorMultiMasterLeaderElection election;

    public CuratorMultiMasterLeaderRoutePolicy(String uri, int enabledCount) {
        this.uri = uri;
        this.enabledCount = enabledCount;
    }

    public CuratorMultiMasterLeaderRoutePolicy(String uri) {
        this(uri, 1);
    }

    public void onInit(Route route) {
        this.ensureElectionIsCreated();
        LOG.info("Route managed by {}. Setting route [{}] AutoStartup flag to false.", this.getClass(), (Object)route.getId());
        route.getRouteContext().setAutoStartup(Boolean.valueOf(false));
        if (this.election.isMaster()) {
            if (this.shouldStopRoute) {
                this.startManagedRoute(route);
            }
        } else if (this.shouldStopRoute) {
            this.stopManagedRoute(route);
        }
    }

    private void ensureElectionIsCreated() {
        if (this.election == null) {
            this.electionLock.lock();
            try {
                if (this.election == null) {
                    this.election = new CuratorMultiMasterLeaderElection(this.uri, this.enabledCount);
                    this.election.addElectionWatcher(this);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.electionLock.unlock();
            }
        }
    }

    private void startManagedRoute(Route route) {
        try {
            this.lock.lock();
            if (this.suspendedRoutes.contains(route)) {
                this.startRoute(route);
                this.suspendedRoutes.remove(route);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void stopManagedRoute(Route route) {
        try {
            this.lock.lock();
            if (!this.suspendedRoutes.contains(route) && !this.shouldProcessExchanges.get()) {
                this.stopRoute(route);
                this.suspendedRoutes.add(route);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void electionResultChanged() {
        if (this.election.isMaster()) {
            this.startAllStoppedRoutes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAllStoppedRoutes() {
        try {
            this.lock.lock();
            if (!this.suspendedRoutes.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.info("{} route(s) have been stopped previously by policy, restarting.", (Object)this.suspendedRoutes.size());
                }
                for (Route suspended : this.suspendedRoutes) {
                    CamelContext ctx = suspended.getCamelContext();
                    while (!ctx.isStarted()) {
                        this.log.info("Context {} is not started yet. Sleeping for a bit.", (Object)ctx.getName());
                        Thread.sleep(5000L);
                    }
                    this.log.info("Starting route [{}] defined in context [{}].", (Object)suspended.getId(), (Object)ctx.getName());
                    this.startRoute(suspended);
                }
                this.suspendedRoutes.clear();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void doShutdown() throws Exception {
        try {
            this.electionLock.lock();
            this.election.shutdownClients();
            this.election = null;
        }
        finally {
            this.electionLock.unlock();
        }
    }

    public CuratorMultiMasterLeaderElection getElection() {
        return this.election;
    }
}

