/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.zipkin;

import brave.SpanCustomizer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.zipkin.ZipkinHelper;
import org.apache.camel.zipkin.ZipkinTracer;

class ZipkinServerResponseAdapter {
    private final ZipkinTracer eventNotifier;
    private final Endpoint endpoint;
    private final String url;

    ZipkinServerResponseAdapter(ZipkinTracer eventNotifier, Exchange exchange) {
        this.eventNotifier = eventNotifier;
        this.endpoint = exchange.getFromEndpoint();
        this.url = URISupport.sanitizeUri((String)this.endpoint.getEndpointUri());
    }

    void onResponse(Exchange exchange, SpanCustomizer span) {
        String responseCode;
        String id = exchange.getExchangeId();
        String mep = exchange.getPattern().name();
        span.tag("camel.server.endpoint.url", this.url);
        span.tag("camel.server.exchange.id", id);
        span.tag("camel.server.exchange.pattern", mep);
        if (exchange.getException() != null) {
            String message = exchange.getException().getMessage();
            span.tag("camel.server.exchange.failure", message);
        } else if (this.eventNotifier.isIncludeMessageBody() || this.eventNotifier.isIncludeMessageBodyStreams()) {
            boolean streams = this.eventNotifier.isIncludeMessageBodyStreams();
            StreamCache cache = ZipkinHelper.prepareBodyForLogging(exchange, streams);
            String body = MessageHelper.extractBodyForLogging((Message)(exchange.hasOut() ? exchange.getOut() : exchange.getIn()), (String)"", (boolean)streams, (boolean)streams);
            span.tag("camel.server.exchange.message.response.body", body);
            if (cache != null) {
                cache.reset();
            }
        }
        String string = responseCode = exchange.hasOut() ? (String)exchange.getOut().getHeader("CamelHttpResponseCode", String.class) : (String)exchange.getIn().getHeader("CamelHttpResponseCode", String.class);
        if (responseCode != null) {
            span.tag("camel.server.exchange.message.response.code", responseCode);
        }
    }
}

