/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.zipkin;

import brave.SpanCustomizer;
import java.util.Locale;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.zipkin.ZipkinHelper;
import org.apache.camel.zipkin.ZipkinTracer;

class ZipkinServerRequestAdapter {
    private final ZipkinTracer eventNotifier;
    private final Endpoint endpoint;
    private final String spanName;
    private final String url;

    ZipkinServerRequestAdapter(ZipkinTracer eventNotifier, Exchange exchange) {
        this.eventNotifier = eventNotifier;
        this.endpoint = exchange.getFromEndpoint();
        this.spanName = URISupport.sanitizeUri((String)this.endpoint.getEndpointKey()).toLowerCase(Locale.ROOT);
        this.url = URISupport.sanitizeUri((String)this.endpoint.getEndpointUri());
    }

    void onRequest(Exchange exchange, SpanCustomizer span) {
        span.name(this.spanName);
        span.tag("camel.server.endpoint.url", this.url);
        span.tag("camel.server.exchange.id", exchange.getExchangeId());
        span.tag("camel.server.exchange.pattern", exchange.getPattern().name());
        if (this.eventNotifier.isIncludeMessageBody() || this.eventNotifier.isIncludeMessageBodyStreams()) {
            boolean streams = this.eventNotifier.isIncludeMessageBodyStreams();
            StreamCache cache = ZipkinHelper.prepareBodyForLogging(exchange, streams);
            String body = MessageHelper.extractBodyForLogging((Message)(exchange.hasOut() ? exchange.getOut() : exchange.getIn()), (String)"", (boolean)streams, (boolean)streams);
            span.tag("camel.server.exchange.message.request.body", body);
            if (cache != null) {
                cache.reset();
            }
        }
    }
}

