/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.crypto.CryptoOperation;
import org.apache.camel.component.crypto.DigitalSignatureComponent;
import org.apache.camel.component.crypto.DigitalSignatureConfiguration;
import org.apache.camel.component.crypto.DigitalSignatureProducer;
import org.apache.camel.component.crypto.processor.SigningProcessor;
import org.apache.camel.component.crypto.processor.VerifyingProcessor;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.3.0", scheme="crypto", title="Crypto (JCE)", syntax="crypto:cryptoOperation:name", producerOnly=true, label="security,transformation")
public class DigitalSignatureEndpoint
extends DefaultEndpoint {
    @UriParam
    private DigitalSignatureConfiguration configuration;

    public DigitalSignatureEndpoint(String uri, DigitalSignatureComponent component, DigitalSignatureConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        if (CryptoOperation.sign == this.configuration.getCryptoOperation()) {
            return new DigitalSignatureProducer(this, new SigningProcessor(this.configuration));
        }
        return new DigitalSignatureProducer(this, new VerifyingProcessor(this.configuration));
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Digital Signatures endpoints are not meant to be consumed from. They are meant be used as an intermediate endpoints");
    }

    public void setConfiguration(DigitalSignatureConfiguration configuration) {
        this.configuration = configuration;
    }

    public DigitalSignatureConfiguration getConfiguration() {
        return this.configuration;
    }

    public PublicKey getPublicKey() throws Exception {
        return this.getConfiguration().getPublicKey();
    }

    public void setPublicKey(PublicKey publicKey) {
        this.getConfiguration().setPublicKey(publicKey);
    }

    public void setPublicKey(String publicKeyName) {
        this.getConfiguration().setPublicKeyName(publicKeyName);
    }

    public Certificate getCertificate() throws Exception {
        return this.getConfiguration().getCertificate();
    }

    public PrivateKey getPrivateKey() throws Exception {
        return this.getConfiguration().getPrivateKey();
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.getConfiguration().setPrivateKey(privateKey);
    }

    public KeyStore getKeystore() {
        return this.getConfiguration().getKeystore();
    }

    public void setKeystore(KeyStore keystore) {
        this.getConfiguration().setKeystore(keystore);
    }

    public char[] getPassword() {
        return this.getConfiguration().getPassword();
    }

    public void setKeyPassword(char[] keyPassword) {
        this.getConfiguration().setPassword(keyPassword);
    }

    public SecureRandom getSecureRandom() {
        return this.getConfiguration().getSecureRandom();
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.getConfiguration().setSecureRandom(secureRandom);
    }

    public String getAlgorithm() {
        return this.getConfiguration().getAlgorithm();
    }

    public void setAlgorithm(String algorithm) {
        this.getConfiguration().setAlgorithm(algorithm);
    }

    public Integer getBuffersize() {
        return this.getConfiguration().getBufferSize();
    }

    public void setBuffersize(Integer buffersize) {
        this.getConfiguration().setBufferSize(buffersize);
    }

    public String getProvider() {
        return this.getConfiguration().getProvider();
    }

    public void setProvider(String provider) {
        this.getConfiguration().setProvider(provider);
    }

    public String getSignatureHeader() {
        return this.getConfiguration().getSignatureHeaderName();
    }

    public void setSignatureHeader(String signatureHeaderName) {
        this.getConfiguration().setSignatureHeaderName(signatureHeaderName);
    }

    public String getAlias() {
        return this.getConfiguration().getAlias();
    }

    public void setAlias(String alias) {
        this.getConfiguration().setAlias(alias);
    }

    public boolean isClearHeaders() {
        return this.getConfiguration().isClearHeaders();
    }

    public void setClearHeaders(boolean clearHeaders) {
        this.getConfiguration().setClearHeaders(clearHeaders);
    }
}

