/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.sql.SqlEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.PropertyBindingSupport;
import org.springframework.jdbc.core.JdbcTemplate;

@org.apache.camel.spi.annotations.Component(value="sql")
public class SqlComponent
extends DefaultComponent {
    private DataSource dataSource;
    @Metadata(label="advanced", defaultValue="true")
    private boolean usePlaceholder = true;

    public SqlComponent() {
    }

    public SqlComponent(Class<? extends Endpoint> endpointClass) {
    }

    public SqlComponent(CamelContext context) {
        super(context);
    }

    public SqlComponent(CamelContext context, Class<? extends Endpoint> endpointClass) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String onConsumeBatchComplete;
        String onConsumeFailed;
        String onConsume;
        DataSource target = null;
        DataSource ds = (DataSource)this.resolveAndRemoveReferenceParameter(parameters, "dataSource", DataSource.class);
        if (ds != null) {
            target = ds;
        }
        String dataSourceRef = (String)this.getAndRemoveParameter(parameters, "dataSourceRef", String.class);
        if (target == null && dataSourceRef != null) {
            target = (DataSource)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)dataSourceRef, DataSource.class);
        }
        if (target == null) {
            target = this.dataSource;
        }
        if (target == null) {
            Set dataSources = this.getCamelContext().getRegistry().findByType(DataSource.class);
            if (dataSources.size() > 1) {
                throw new IllegalArgumentException("Multiple DataSources found in the registry and no explicit configuration provided");
            }
            if (dataSources.size() == 1) {
                target = dataSources.stream().findFirst().orElse(null);
            }
        }
        if (target == null) {
            throw new IllegalArgumentException("DataSource must be configured");
        }
        this.log.debug("Using default DataSource discovered from registry: {}", (Object)target);
        String parameterPlaceholderSubstitute = (String)this.getAndRemoveParameter(parameters, "placeholder", String.class, "#");
        JdbcTemplate jdbcTemplate = new JdbcTemplate(target);
        Map templateOptions = IntrospectionSupport.extractProperties(parameters, (String)"template.");
        PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), (Object)jdbcTemplate, (Map)templateOptions);
        String query = remaining;
        if (this.usePlaceholder) {
            query = query.replaceAll(parameterPlaceholderSubstitute, "?");
        }
        if ((onConsume = (String)this.getAndRemoveParameter(parameters, "consumer.onConsume", String.class)) == null) {
            onConsume = (String)this.getAndRemoveParameter(parameters, "onConsume", String.class);
        }
        if (onConsume != null && this.usePlaceholder) {
            onConsume = onConsume.replaceAll(parameterPlaceholderSubstitute, "?");
        }
        if ((onConsumeFailed = (String)this.getAndRemoveParameter(parameters, "consumer.onConsumeFailed", String.class)) == null) {
            onConsumeFailed = (String)this.getAndRemoveParameter(parameters, "onConsumeFailed", String.class);
        }
        if (onConsumeFailed != null && this.usePlaceholder) {
            onConsumeFailed = onConsumeFailed.replaceAll(parameterPlaceholderSubstitute, "?");
        }
        if ((onConsumeBatchComplete = (String)this.getAndRemoveParameter(parameters, "consumer.onConsumeBatchComplete", String.class)) == null) {
            onConsumeBatchComplete = (String)this.getAndRemoveParameter(parameters, "onConsumeBatchComplete", String.class);
        }
        if (onConsumeBatchComplete != null && this.usePlaceholder) {
            onConsumeBatchComplete = onConsumeBatchComplete.replaceAll(parameterPlaceholderSubstitute, "?");
        }
        SqlEndpoint endpoint = new SqlEndpoint(uri, (Component)this, jdbcTemplate, query);
        endpoint.setPlaceholder(parameterPlaceholderSubstitute);
        endpoint.setUsePlaceholder(this.isUsePlaceholder());
        endpoint.setOnConsume(onConsume);
        endpoint.setOnConsumeFailed(onConsumeFailed);
        endpoint.setOnConsumeBatchComplete(onConsumeBatchComplete);
        endpoint.setDataSource(ds);
        endpoint.setDataSourceRef(dataSourceRef);
        endpoint.setTemplateOptions(templateOptions);
        return endpoint;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setUsePlaceholder(boolean usePlaceholder) {
        this.usePlaceholder = usePlaceholder;
    }

    public boolean isUsePlaceholder() {
        return this.usePlaceholder;
    }
}

