/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.service.lra;

import java.net.URL;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.Exchange;
import org.apache.camel.saga.CamelSagaCoordinator;
import org.apache.camel.saga.CamelSagaStep;
import org.apache.camel.service.lra.LRASagaService;
import org.apache.camel.service.lra.LRASagaStep;
import org.apache.camel.util.ObjectHelper;

public class LRASagaCoordinator
implements CamelSagaCoordinator {
    private LRASagaService sagaService;
    private URL lraURL;

    public LRASagaCoordinator(LRASagaService sagaService, URL lraURL) {
        this.sagaService = (LRASagaService)((Object)ObjectHelper.notNull((Object)((Object)sagaService), (String)"sagaService"));
        this.lraURL = (URL)ObjectHelper.notNull((Object)lraURL, (String)"lraURL");
    }

    public CompletableFuture<Void> beginStep(Exchange exchange, CamelSagaStep step) {
        LRASagaStep sagaStep;
        try {
            sagaStep = LRASagaStep.fromCamelSagaStep(step, exchange);
        }
        catch (RuntimeException ex) {
            return CompletableFuture.supplyAsync(() -> {
                throw ex;
            });
        }
        return this.sagaService.getClient().join(this.lraURL, sagaStep);
    }

    public CompletableFuture<Void> compensate() {
        return this.sagaService.getClient().compensate(this.lraURL);
    }

    public CompletableFuture<Void> complete() {
        return this.sagaService.getClient().complete(this.lraURL);
    }

    public String getId() {
        return this.lraURL.toString();
    }
}

