/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.iam;

import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.iam.IAMComponentVerifierExtension;
import org.apache.camel.component.aws.iam.IAMConfiguration;
import org.apache.camel.component.aws.iam.IAMEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@org.apache.camel.spi.annotations.Component(value="aws-iam")
public class IAMComponent
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private IAMConfiguration configuration = new IAMConfiguration();

    public IAMComponent() {
        this(null);
    }

    public IAMComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new IAMComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        IAMConfiguration configuration = this.configuration.copy();
        this.setProperties(configuration, parameters);
        if (ObjectHelper.isEmpty((Object)configuration.getAccessKey())) {
            this.setAccessKey(this.accessKey);
        }
        if (ObjectHelper.isEmpty((Object)configuration.getSecretKey())) {
            this.setSecretKey(this.secretKey);
        }
        if (ObjectHelper.isEmpty((Object)configuration.getRegion())) {
            this.setRegion(this.region);
        }
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getIamClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon IAM client or accessKey and secretKey must be specified");
        }
        IAMEndpoint endpoint = new IAMEndpoint(uri, (Component)this, configuration);
        return endpoint;
    }

    public IAMConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IAMConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.configuration.getAccessKey();
    }

    public void setAccessKey(String accessKey) {
        this.configuration.setAccessKey(accessKey);
    }

    public String getSecretKey() {
        return this.configuration.getSecretKey();
    }

    public void setSecretKey(String secretKey) {
        this.configuration.setSecretKey(secretKey);
    }

    public String getRegion() {
        return this.configuration.getRegion();
    }

    public void setRegion(String region) {
        this.configuration.setRegion(region);
    }

    private void checkAndSetRegistryClient(IAMConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AmazonIdentityManagement.class);
        if (clients.size() == 1) {
            configuration.setIamClient((AmazonIdentityManagement)clients.stream().findFirst().get());
        }
    }
}

