/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sparkrest;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.sparkrest.CamelSparkRoute;
import org.apache.camel.component.sparkrest.SparkBinding;
import org.apache.camel.component.sparkrest.SparkComponent;
import org.apache.camel.component.sparkrest.SparkConfiguration;
import org.apache.camel.component.sparkrest.SparkConsumer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.StringHelper;
import spark.route.HttpMethod;

@UriEndpoint(firstVersion="2.14.0", scheme="spark-rest", title="Spark Rest", syntax="spark-rest:verb:path", consumerOnly=true, label="rest")
public class SparkEndpoint
extends DefaultEndpoint {
    @UriPath(enums="get,post,put,patch,delete,head,trace,connect,options")
    @Metadata(required=true)
    private String verb;
    @UriPath
    @Metadata(required=true)
    private String path;
    @UriParam
    private String accept;
    @UriParam
    private SparkConfiguration sparkConfiguration;
    @UriParam(label="advanced")
    private SparkBinding sparkBinding;

    public SparkEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public SparkConfiguration getSparkConfiguration() {
        return this.sparkConfiguration;
    }

    public void setSparkConfiguration(SparkConfiguration sparkConfiguration) {
        this.sparkConfiguration = sparkConfiguration;
    }

    public SparkBinding getSparkBinding() {
        return this.sparkBinding;
    }

    public void setSparkBinding(SparkBinding sparkBinding) {
        this.sparkBinding = sparkBinding;
    }

    public String getVerb() {
        return this.verb;
    }

    public void setVerb(String verb) {
        this.verb = verb;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getAccept() {
        return this.accept;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Producer not supported");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        CamelSparkRoute route = new CamelSparkRoute(this, processor);
        SparkConsumer consumer = new SparkConsumer((Endpoint)this, processor, route);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected void doStart() throws Exception {
        super.doStart();
        StringHelper.notEmpty((String)this.verb, (String)"verb", (Object)((Object)this));
        StringHelper.notEmpty((String)this.path, (String)"path", (Object)((Object)this));
        HttpMethod method = (HttpMethod)this.getCamelContext().getTypeConverter().mandatoryConvertTo(HttpMethod.class, (Object)this.verb);
        this.verb = method.name();
    }

    public SparkComponent getComponent() {
        return (SparkComponent)super.getComponent();
    }
}

