/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb.springboot;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.camel.component.aws.ddb.DdbConfiguration;
import org.apache.camel.component.aws.ddb.DdbOperations;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="camel.component.aws-ddb")
public class DdbComponentConfiguration
extends ComponentConfigurationPropertiesCommon {
    private Boolean enabled;
    private DdbConfigurationNestedConfiguration configuration;
    private String accessKey;
    private String secretKey;
    private String region;
    private Boolean resolvePropertyPlaceholders = true;
    private Boolean basicPropertyBinding = false;

    public DdbConfigurationNestedConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DdbConfigurationNestedConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Boolean getResolvePropertyPlaceholders() {
        return this.resolvePropertyPlaceholders;
    }

    public void setResolvePropertyPlaceholders(Boolean resolvePropertyPlaceholders) {
        this.resolvePropertyPlaceholders = resolvePropertyPlaceholders;
    }

    public Boolean getBasicPropertyBinding() {
        return this.basicPropertyBinding;
    }

    public void setBasicPropertyBinding(Boolean basicPropertyBinding) {
        this.basicPropertyBinding = basicPropertyBinding;
    }

    public static class DdbConfigurationNestedConfiguration {
        public static final Class CAMEL_NESTED_CLASS = DdbConfiguration.class;
        private String accessKey;
        private String secretKey;
        private AmazonDynamoDB amazonDDBClient;
        private String tableName;
        private DdbOperations operation = DdbOperations.PutItem;
        private Boolean consistentRead = false;
        private Long readCapacity;
        private Long writeCapacity;
        private String keyAttributeName;
        private String keyAttributeType;
        private String proxyHost;
        private Integer proxyPort;
        private String region;

        public String getAccessKey() {
            return this.accessKey;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public AmazonDynamoDB getAmazonDDBClient() {
            return this.amazonDDBClient;
        }

        public void setAmazonDDBClient(AmazonDynamoDB amazonDDBClient) {
            this.amazonDDBClient = amazonDDBClient;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public DdbOperations getOperation() {
            return this.operation;
        }

        public void setOperation(DdbOperations operation) {
            this.operation = operation;
        }

        public Boolean getConsistentRead() {
            return this.consistentRead;
        }

        public void setConsistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
        }

        public Long getReadCapacity() {
            return this.readCapacity;
        }

        public void setReadCapacity(Long readCapacity) {
            this.readCapacity = readCapacity;
        }

        public Long getWriteCapacity() {
            return this.writeCapacity;
        }

        public void setWriteCapacity(Long writeCapacity) {
            this.writeCapacity = writeCapacity;
        }

        public String getKeyAttributeName() {
            return this.keyAttributeName;
        }

        public void setKeyAttributeName(String keyAttributeName) {
            this.keyAttributeName = keyAttributeName;
        }

        public String getKeyAttributeType() {
            return this.keyAttributeType;
        }

        public void setKeyAttributeType(String keyAttributeType) {
            this.keyAttributeType = keyAttributeType;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public void setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
        }

        public Integer getProxyPort() {
            return this.proxyPort;
        }

        public void setProxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
        }

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }
    }
}

