/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.braintree.internal;

import com.braintreegateway.ResourceCollection;
import com.braintreegateway.Result;
import com.braintreegateway.Transaction;
import com.braintreegateway.TransactionCloneRequest;
import com.braintreegateway.TransactionGateway;
import com.braintreegateway.TransactionRefundRequest;
import com.braintreegateway.TransactionRequest;
import com.braintreegateway.TransactionSearchRequest;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.List;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

public enum TransactionGatewayApiMethod implements ApiMethod
{
    CANCELRELEASE(Result.class, "cancelRelease", ApiMethodArg.arg((String)"id", String.class)),
    CLONETRANSACTION(Result.class, "cloneTransaction", ApiMethodArg.arg((String)"id", String.class), ApiMethodArg.arg((String)"cloneRequest", TransactionCloneRequest.class)),
    CREDIT(Result.class, "credit", ApiMethodArg.arg((String)"request", TransactionRequest.class)),
    FIND(Transaction.class, "find", ApiMethodArg.arg((String)"id", String.class)),
    HOLDINESCROW(Result.class, "holdInEscrow", ApiMethodArg.arg((String)"id", String.class)),
    REFUND(Result.class, "refund", ApiMethodArg.arg((String)"id", String.class)),
    REFUND_1(Result.class, "refund", ApiMethodArg.arg((String)"id", String.class), ApiMethodArg.arg((String)"amount", BigDecimal.class)),
    REFUND_2(Result.class, "refund", ApiMethodArg.arg((String)"id", String.class), ApiMethodArg.arg((String)"refundRequest", TransactionRefundRequest.class)),
    RELEASEFROMESCROW(Result.class, "releaseFromEscrow", ApiMethodArg.arg((String)"id", String.class)),
    SALE(Result.class, "sale", ApiMethodArg.arg((String)"request", TransactionRequest.class)),
    SEARCH(ResourceCollection.class, "search", ApiMethodArg.arg((String)"query", TransactionSearchRequest.class)),
    SUBMITFORPARTIALSETTLEMENT(Result.class, "submitForPartialSettlement", ApiMethodArg.arg((String)"id", String.class), ApiMethodArg.arg((String)"amount", BigDecimal.class)),
    SUBMITFORPARTIALSETTLEMENT_1(Result.class, "submitForPartialSettlement", ApiMethodArg.arg((String)"id", String.class), ApiMethodArg.arg((String)"request", TransactionRequest.class)),
    SUBMITFORSETTLEMENT(Result.class, "submitForSettlement", ApiMethodArg.arg((String)"id", String.class)),
    SUBMITFORSETTLEMENT_1(Result.class, "submitForSettlement", ApiMethodArg.arg((String)"id", String.class), ApiMethodArg.arg((String)"amount", BigDecimal.class)),
    SUBMITFORSETTLEMENT_2(Result.class, "submitForSettlement", ApiMethodArg.arg((String)"id", String.class), ApiMethodArg.arg((String)"request", TransactionRequest.class)),
    UPDATEDETAILS(Result.class, "updateDetails", ApiMethodArg.arg((String)"id", String.class), ApiMethodArg.arg((String)"request", TransactionRequest.class)),
    VOIDTRANSACTION(Result.class, "voidTransaction", ApiMethodArg.arg((String)"id", String.class));

    private final ApiMethod apiMethod;

    private TransactionGatewayApiMethod(Class<?> resultType, String name, ApiMethodArg ... args) {
        this.apiMethod = new ApiMethodImpl(TransactionGateway.class, resultType, name, args);
    }

    public String getName() {
        return this.apiMethod.getName();
    }

    public Class<?> getResultType() {
        return this.apiMethod.getResultType();
    }

    public List<String> getArgNames() {
        return this.apiMethod.getArgNames();
    }

    public List<Class<?>> getArgTypes() {
        return this.apiMethod.getArgTypes();
    }

    public Method getMethod() {
        return this.apiMethod.getMethod();
    }
}

