/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFileVersion;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxSharedLink;
import com.box.sdk.FileUploadParams;
import com.box.sdk.Metadata;
import com.box.sdk.ProgressListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxFilesManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxFilesManager.class);
    private BoxAPIConnection boxConnection;

    public BoxFilesManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public BoxFile.Info getFileInfo(String fileId, String ... fields) {
        try {
            LOG.debug("Getting info for file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            if (fields == null || fields.length == 0) {
                return file.getInfo();
            }
            return file.getInfo(fields);
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxFile updateFileInfo(String fileId, BoxFile.Info info) {
        try {
            LOG.debug("Updating info for file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (info == null) {
                throw new IllegalArgumentException("Parameter 'info' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            file.updateInfo(info);
            return file;
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxFile uploadFile(String parentFolderId, InputStream content, String fileName, Date created, Date modified, Long size, ProgressListener listener) {
        try {
            LOG.debug("Uploading file with name '" + fileName + "' to parent_folder(id=" + parentFolderId + ")");
            if (parentFolderId == null) {
                throw new IllegalArgumentException("Parameter 'parentFolderId' can not be null");
            }
            if (content == null) {
                throw new IllegalArgumentException("Paramerer 'content' can not be null");
            }
            if (fileName == null) {
                throw new IllegalArgumentException("Paramerer 'fileName' can not be null");
            }
            BoxFolder parentFolder = new BoxFolder(this.boxConnection, parentFolderId);
            FileUploadParams uploadParams = new FileUploadParams();
            uploadParams.setName(fileName);
            uploadParams.setContent(content);
            if (created != null) {
                uploadParams.setCreated(created);
            }
            if (modified != null) {
                uploadParams.setModified(modified);
            }
            if (size != null) {
                uploadParams.setSize(size.longValue());
            }
            if (listener != null) {
                uploadParams.setProgressListener(listener);
            }
            return parentFolder.uploadFile(uploadParams).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxFile uploadNewFileVersion(String fileId, InputStream fileContent, Date modified, Long fileSize, ProgressListener listener) {
        try {
            LOG.debug("Uploading new version of file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (fileContent == null) {
                throw new IllegalArgumentException("Paramerer 'fileContent' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            if (modified != null) {
                if (fileSize != null) {
                    file.uploadNewVersion(fileContent, modified, fileSize.longValue(), listener);
                } else {
                    file.uploadNewVersion(fileContent, modified, 0L, listener);
                }
            } else {
                file.uploadNewVersion(fileContent);
            }
            return file;
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public Collection<BoxFileVersion> getFileVersions(String fileId) {
        try {
            LOG.debug("Getting versions of file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            return file.getVersions();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public OutputStream downloadFile(String fileId, OutputStream output, Long rangeStart, Long rangeEnd, ProgressListener listener) {
        try {
            LOG.debug("Downloading file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (output == null) {
                throw new IllegalArgumentException("Parameter 'output' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            if (listener != null) {
                if (rangeStart != null && rangeEnd != null) {
                    file.downloadRange(output, rangeStart.longValue(), rangeEnd.longValue(), listener);
                } else {
                    file.download(output, listener);
                }
            } else if (rangeStart != null && rangeEnd != null) {
                file.downloadRange(output, rangeStart.longValue(), rangeEnd.longValue());
            } else {
                file.download(output);
            }
            return output;
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public OutputStream downloadPreviousFileVersion(String fileId, Integer version, OutputStream output, ProgressListener listener) {
        try {
            LOG.debug("Downloading file(id=" + fileId + ", version=" + version + ")");
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (version == null) {
                throw new IllegalArgumentException("Parameter 'version' can not be null");
            }
            if (output == null) {
                throw new IllegalArgumentException("Parameter 'output' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            List fileVersions = (List)file.getVersions();
            BoxFileVersion fileVersion = (BoxFileVersion)fileVersions.get(version);
            if (listener != null) {
                fileVersion.download(output, listener);
            } else {
                fileVersion.download(output);
            }
            return output;
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxFileVersion promoteFileVersion(String fileId, Integer version) {
        try {
            LOG.debug("Promoting file(id=" + fileId + ", version=" + version + ")");
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (version == null) {
                throw new IllegalArgumentException("Parameter 'version' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            List fileVersions = (List)file.getVersions();
            BoxFileVersion fileVersion = (BoxFileVersion)fileVersions.get(version);
            fileVersion.promote();
            return fileVersion;
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxFile copyFile(String fileId, String destinationFolderId, String newName) {
        try {
            LOG.debug("Copying file(id=" + fileId + ") to destination_folder(id=" + destinationFolderId + ")" + (newName == null ? "" : " with new name '" + newName + "'"));
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (destinationFolderId == null) {
                throw new IllegalArgumentException("Parameter 'destinationFolderId' can not be null");
            }
            BoxFile fileToCopy = new BoxFile(this.boxConnection, fileId);
            BoxFolder destinationFolder = new BoxFolder(this.boxConnection, destinationFolderId);
            if (newName == null) {
                return fileToCopy.copy(destinationFolder).getResource();
            }
            return fileToCopy.copy(destinationFolder, newName).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxFile moveFile(String fileId, String destinationFolderId, String newName) {
        try {
            LOG.debug("Moving file(id=" + fileId + ") to destination_folder(id=" + destinationFolderId + ")" + (newName == null ? "" : " with new name '" + newName + "'"));
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (destinationFolderId == null) {
                throw new IllegalArgumentException("Parameter 'destinationFolderId' can not be null");
            }
            BoxFile fileToMove = new BoxFile(this.boxConnection, fileId);
            BoxFolder destinationFolder = new BoxFolder(this.boxConnection, destinationFolderId);
            if (newName == null) {
                return (BoxFile)fileToMove.move(destinationFolder).getResource();
            }
            return (BoxFile)fileToMove.move(destinationFolder, newName).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxFile renameFile(String fileId, String newFileName) {
        try {
            LOG.debug("Renaming file(id=" + fileId + ") to '" + newFileName + "'");
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (newFileName == null) {
                throw new IllegalArgumentException("Parameter 'newName' can not be null");
            }
            BoxFile fileToRename = new BoxFile(this.boxConnection, fileId);
            fileToRename.rename(newFileName);
            return fileToRename;
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public void deleteFile(String fileId) {
        try {
            LOG.debug("Deleting file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            file.delete();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public void deleteFileVersion(String fileId, Integer version) {
        try {
            LOG.debug("Deleting file(id=" + fileId + ", version=" + version + ")");
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (version == null) {
                throw new IllegalArgumentException("Parameter 'version' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            List versions = (List)file.getVersions();
            BoxFileVersion fileVersion = (BoxFileVersion)versions.get(version);
            fileVersion.delete();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxSharedLink createFileSharedLink(String fileId, BoxSharedLink.Access access, Date unshareDate, BoxSharedLink.Permissions permissions) {
        try {
            LOG.debug("Creating shared link for file(id=" + fileId + ") with access=" + access + (unshareDate == null ? "" : " unsharedDate=" + DateFormat.getDateTimeInstance().format(unshareDate) + " permissions=" + permissions));
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (access == null) {
                throw new IllegalArgumentException("Parameter 'access' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            return file.createSharedLink(access, unshareDate, permissions);
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public URL getDownloadURL(String fileId) {
        try {
            LOG.debug("Getting download URL for file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            return file.getDownloadURL();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public URL getFilePreviewLink(String fileId) {
        try {
            LOG.debug("Getting preview link for file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            return file.getPreviewLink();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public byte[] getFileThumbnail(String fileId, BoxFile.ThumbnailFileType fileType, Integer minWidth, Integer minHeight, Integer maxWidth, Integer maxHeight) {
        try {
            LOG.debug("Getting thumbnail for file(id=" + fileId + ") fileType=" + fileType + " minWidth=" + minWidth + " minHeight=" + minHeight + " maxWidth=" + maxWidth + " maxHeight=" + maxHeight);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (fileType == null) {
                throw new IllegalArgumentException("Parameter 'fileType' can not be null");
            }
            if (minWidth == null) {
                throw new IllegalArgumentException("Parameter 'minWidth' can not be null");
            }
            if (minHeight == null) {
                throw new IllegalArgumentException("Parameter 'minHeight' can not be null");
            }
            if (maxWidth == null) {
                throw new IllegalArgumentException("Parameter 'maxWidth' can not be null");
            }
            if (maxHeight == null) {
                throw new IllegalArgumentException("Parameter 'maxHeight' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            return file.getThumbnail(fileType, minWidth.intValue(), minHeight.intValue(), maxWidth.intValue(), maxHeight.intValue());
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public Metadata createFileMetadata(String fileId, Metadata metadata, String typeName) {
        try {
            LOG.debug("Creating metadata for file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (metadata == null) {
                throw new IllegalArgumentException("Parameter 'metadata' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            if (typeName != null) {
                return file.createMetadata(typeName, metadata);
            }
            return file.createMetadata(metadata);
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public Metadata getFileMetadata(String fileId, String typeName) {
        try {
            LOG.debug("Get metadata for file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            if (typeName != null) {
                return file.getMetadata(typeName);
            }
            return file.getMetadata();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public Metadata updateFileMetadata(String fileId, Metadata metadata) {
        try {
            LOG.debug("Updating metadata for file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (metadata == null) {
                throw new IllegalArgumentException("Parameter 'metadata' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            return file.updateMetadata(metadata);
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public void deleteFileMetadata(String fileId) {
        try {
            LOG.debug("Deleting metadata for file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            file.deleteMetadata();
        }
        catch (BoxAPIException e) {
            throw new RuntimeException(String.format("Box API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }
}

