/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddbstream;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.model.DescribeStreamRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeStreamResult;
import com.amazonaws.services.dynamodbv2.model.GetShardIteratorRequest;
import com.amazonaws.services.dynamodbv2.model.GetShardIteratorResult;
import com.amazonaws.services.dynamodbv2.model.ListStreamsRequest;
import com.amazonaws.services.dynamodbv2.model.ListStreamsResult;
import com.amazonaws.services.dynamodbv2.model.Shard;
import com.amazonaws.services.dynamodbv2.model.ShardIteratorType;
import com.amazonaws.services.dynamodbv2.model.Stream;
import java.math.BigInteger;
import org.apache.camel.component.aws.ddbstream.BigIntComparisons;
import org.apache.camel.component.aws.ddbstream.DdbStreamEndpoint;
import org.apache.camel.component.aws.ddbstream.ShardList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShardIteratorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ShardIteratorHandler.class);
    private final DdbStreamEndpoint endpoint;
    private final ShardList shardList = new ShardList();
    private String currentShardIterator;
    private Shard currentShard;

    ShardIteratorHandler(DdbStreamEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    String getShardIterator(String resumeFromSequenceNumber) {
        ShardIteratorType iteratorType = this.getEndpoint().getConfiguration().getIteratorType();
        String sequenceNumber = this.getEndpoint().getSequenceNumber();
        if (resumeFromSequenceNumber != null) {
            this.currentShard = null;
            this.currentShardIterator = null;
            iteratorType = ShardIteratorType.AFTER_SEQUENCE_NUMBER;
            sequenceNumber = resumeFromSequenceNumber;
        }
        if (this.currentShardIterator == null) {
            ListStreamsResult streamsListResult = this.getClient().listStreams(new ListStreamsRequest().withTableName(this.getEndpoint().getConfiguration().getTableName()));
            String streamArn = ((Stream)streamsListResult.getStreams().get(0)).getStreamArn();
            DescribeStreamResult streamDescriptionResult = this.getClient().describeStream(new DescribeStreamRequest().withStreamArn(streamArn));
            this.shardList.addAll(streamDescriptionResult.getStreamDescription().getShards());
            LOG.trace("Current shard is: {} (in {})", (Object)this.currentShard, (Object)this.shardList);
            this.currentShard = this.currentShard == null ? this.resolveNewShard(iteratorType, resumeFromSequenceNumber) : this.shardList.nextAfter(this.currentShard);
            this.shardList.removeOlderThan(this.currentShard);
            LOG.trace("Next shard is: {} (in {})", (Object)this.currentShard, (Object)this.shardList);
            GetShardIteratorResult result = this.getClient().getShardIterator(this.buildGetShardIteratorRequest(streamArn, iteratorType, sequenceNumber));
            this.currentShardIterator = result.getShardIterator();
        }
        LOG.trace("Shard Iterator is: {}", (Object)this.currentShardIterator);
        return this.currentShardIterator;
    }

    private GetShardIteratorRequest buildGetShardIteratorRequest(String streamArn, ShardIteratorType iteratorType, String sequenceNumber) {
        GetShardIteratorRequest req = new GetShardIteratorRequest().withStreamArn(streamArn).withShardId(this.currentShard.getShardId()).withShardIteratorType(iteratorType);
        switch (iteratorType) {
            case AFTER_SEQUENCE_NUMBER: 
            case AT_SEQUENCE_NUMBER: {
                if (BigIntComparisons.Conditions.LTEQ.matches(new BigInteger(this.currentShard.getSequenceNumberRange().getStartingSequenceNumber()), new BigInteger(sequenceNumber))) {
                    req = req.withSequenceNumber(sequenceNumber);
                    break;
                }
                req = req.withShardIteratorType(ShardIteratorType.TRIM_HORIZON);
                break;
            }
        }
        return req;
    }

    private Shard resolveNewShard(ShardIteratorType type, String resumeFrom) {
        switch (type) {
            case AFTER_SEQUENCE_NUMBER: {
                return this.shardList.afterSeq(resumeFrom != null ? resumeFrom : this.getEndpoint().getSequenceNumber());
            }
            case AT_SEQUENCE_NUMBER: {
                return this.shardList.atSeq(this.getEndpoint().getSequenceNumber());
            }
            case TRIM_HORIZON: {
                return this.shardList.first();
            }
        }
        return this.shardList.last();
    }

    void updateShardIterator(String nextShardIterator) {
        this.currentShardIterator = nextShardIterator;
    }

    DdbStreamEndpoint getEndpoint() {
        return this.endpoint;
    }

    private AmazonDynamoDBStreams getClient() {
        return this.getEndpoint().getClient();
    }
}

