/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import javax.transaction.TransactionRolledbackException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.cdi.transaction.JtaTransactionPolicy;
import org.apache.camel.processor.errorhandler.ErrorHandlerSupport;
import org.apache.camel.processor.errorhandler.ExceptionPolicyStrategy;
import org.apache.camel.spi.ShutdownPrepared;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public class TransactionErrorHandler
extends ErrorHandlerSupport
implements AsyncProcessor,
ShutdownPrepared,
Navigate<Processor> {
    protected final Processor output;
    protected volatile boolean preparingShutdown;
    private ExceptionPolicyStrategy exceptionPolicy;
    private JtaTransactionPolicy transactionPolicy;
    private final String transactionKey;
    private final LoggingLevel rollbackLoggingLevel;

    public TransactionErrorHandler(CamelContext camelContext, Processor output, ExceptionPolicyStrategy exceptionPolicyStrategy, JtaTransactionPolicy transactionPolicy, ScheduledExecutorService executorService, LoggingLevel rollbackLoggingLevel) {
        this.output = output;
        this.transactionPolicy = transactionPolicy;
        this.rollbackLoggingLevel = rollbackLoggingLevel;
        this.transactionKey = ObjectHelper.getIdentityHashCode((Object)transactionPolicy);
        this.setExceptionPolicy(exceptionPolicyStrategy);
    }

    public void process(Exchange exchange) throws Exception {
        if (exchange.getUnitOfWork().isTransactedBy((Object)this.transactionKey)) {
            this.processByErrorHandler(exchange);
        } else {
            this.processInTransaction(exchange);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.process(exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    public CompletableFuture<Exchange> processAsync(Exchange exchange) {
        AsyncCallbackToCompletableFutureAdapter callback = new AsyncCallbackToCompletableFutureAdapter((Object)exchange);
        this.process(exchange, (AsyncCallback)callback);
        return callback.getFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInTransaction(Exchange exchange) throws Exception {
        Boolean externalRedelivered = exchange.isExternalRedelivered();
        String redelivered = externalRedelivered != null ? externalRedelivered.toString() : "unknown";
        String ids = ExchangeHelper.logIds((Exchange)exchange);
        try {
            exchange.getUnitOfWork().beginTransactedBy((Object)this.transactionKey);
            this.logTransactionBegin(redelivered, ids);
            this.doInTransactionTemplate(exchange);
            this.logTransactionCommit(redelivered, ids);
        }
        catch (TransactionRolledbackException e) {
            this.logTransactionRollback(redelivered, ids, null, true);
        }
        catch (Throwable e) {
            exchange.setException(e);
            this.logTransactionRollback(redelivered, ids, e, false);
        }
        finally {
            exchange.getUnitOfWork().endTransactedBy((Object)this.transactionKey);
        }
        Boolean onlyLast = (Boolean)exchange.removeProperty("CamelRollbackOnlyLast");
        if (onlyLast != null && onlyLast.booleanValue()) {
            if (this.log.isDebugEnabled()) {
                Exception cause = exchange.getException();
                if (cause != null) {
                    this.log.debug("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnlyLast and caught: ", new Object[]{this.transactionKey, redelivered, ids, cause});
                } else {
                    this.log.debug("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnlyLast", new Object[]{this.transactionKey, redelivered, ids});
                }
            }
            exchange.setException(null);
        }
    }

    public void setTransactionPolicy(JtaTransactionPolicy transactionPolicy) {
        this.transactionPolicy = transactionPolicy;
    }

    protected void doInTransactionTemplate(final Exchange exchange) throws Throwable {
        this.transactionPolicy.run(new JtaTransactionPolicy.Runnable(){

            @Override
            public void run() throws Throwable {
                TransactionErrorHandler.this.processByErrorHandler(exchange);
                if (exchange.getException() != null || exchange.isRollbackOnly()) {
                    Exception rce = exchange.getException() != null ? exchange.getException() : new TransactionRolledbackException();
                    if (TransactionErrorHandler.this.log.isTraceEnabled()) {
                        TransactionErrorHandler.this.log.trace("Throwing runtime exception to force transaction to rollback on {}", (Object)TransactionErrorHandler.this.transactionPolicy);
                    }
                    throw rce;
                }
            }
        });
    }

    protected void processByErrorHandler(Exchange exchange) {
        try {
            this.output.process(exchange);
        }
        catch (Throwable e) {
            throw new RuntimeCamelException(e);
        }
    }

    private void logTransactionBegin(String redelivered, String ids) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Transaction begin ({}) redelivered({}) for {})", new Object[]{this.transactionKey, redelivered, ids});
        }
    }

    private void logTransactionCommit(String redelivered, String ids) {
        if ("true".equals(redelivered) && (this.rollbackLoggingLevel == LoggingLevel.INFO || this.rollbackLoggingLevel == LoggingLevel.WARN || this.rollbackLoggingLevel == LoggingLevel.ERROR)) {
            this.log.info("Transaction commit ({}) redelivered({}) for {})", new Object[]{this.transactionKey, redelivered, ids});
            return;
        }
        this.log.debug("Transaction commit ({}) redelivered({}) for {})", new Object[]{this.transactionKey, redelivered, ids});
    }

    private void logTransactionRollback(String redelivered, String ids, Throwable e, boolean rollbackOnly) {
        if (this.rollbackLoggingLevel == LoggingLevel.OFF) {
            return;
        }
        if (this.rollbackLoggingLevel == LoggingLevel.ERROR && this.log.isErrorEnabled()) {
            if (rollbackOnly) {
                this.log.error("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnly", new Object[]{this.transactionKey, redelivered, ids});
            } else {
                this.log.error("Transaction rollback ({}) redelivered({}) for {} caught: {}", new Object[]{this.transactionKey, redelivered, ids, e.getMessage()});
            }
        } else if (this.rollbackLoggingLevel == LoggingLevel.WARN && this.log.isWarnEnabled()) {
            if (rollbackOnly) {
                this.log.warn("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnly", new Object[]{this.transactionKey, redelivered, ids});
            } else {
                this.log.warn("Transaction rollback ({}) redelivered({}) for {} caught: {}", new Object[]{this.transactionKey, redelivered, ids, e.getMessage()});
            }
        } else if (this.rollbackLoggingLevel == LoggingLevel.INFO && this.log.isInfoEnabled()) {
            if (rollbackOnly) {
                this.log.info("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnly", new Object[]{this.transactionKey, redelivered, ids});
            } else {
                this.log.info("Transaction rollback ({}) redelivered({}) for {} caught: {}", new Object[]{this.transactionKey, redelivered, ids, e.getMessage()});
            }
        } else if (this.rollbackLoggingLevel == LoggingLevel.DEBUG && this.log.isDebugEnabled()) {
            if (rollbackOnly) {
                this.log.debug("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnly", new Object[]{this.transactionKey, redelivered, ids});
            } else {
                this.log.debug("Transaction rollback ({}) redelivered({}) for {} caught: {}", new Object[]{this.transactionKey, redelivered, ids, e.getMessage()});
            }
        } else if (this.rollbackLoggingLevel == LoggingLevel.TRACE && this.log.isTraceEnabled()) {
            if (rollbackOnly) {
                this.log.trace("Transaction rollback ({}) redelivered({}) for {} due exchange was marked for rollbackOnly", new Object[]{this.transactionKey, redelivered, ids});
            } else {
                this.log.trace("Transaction rollback ({}) redelivered({}) for {} caught: {}", new Object[]{this.transactionKey, redelivered, ids, e.getMessage()});
            }
        }
    }

    public void setExceptionPolicy(ExceptionPolicyStrategy exceptionPolicy) {
        this.exceptionPolicy = exceptionPolicy;
    }

    public ExceptionPolicyStrategy getExceptionPolicy() {
        return this.exceptionPolicy;
    }

    public Processor getOutput() {
        return this.output;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.output);
        this.preparingShutdown = false;
    }

    protected void doStop() throws Exception {
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.output});
    }

    public boolean supportTransacted() {
        return true;
    }

    public boolean hasNext() {
        return this.output != null;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.output);
        return answer;
    }

    public void prepareShutdown(boolean suspendOnly, boolean forced) {
        this.log.trace("Prepare shutdown on error handler {}", (Object)this);
        this.preparingShutdown = true;
    }
}

