/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.camel.BeanInject;
import org.apache.camel.CamelContext;
import org.apache.camel.EndpointInject;
import org.apache.camel.Produce;
import org.apache.camel.PropertyInject;
import org.apache.camel.cdi.BeanManagerHelper;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.cdi.DefaultLiteral;
import org.apache.camel.cdi.Vetoed;
import org.apache.camel.impl.engine.CamelPostProcessorHelper;
import org.apache.camel.impl.engine.DefaultCamelBeanPostProcessor;
import org.apache.camel.util.ReflectionHelper;

@Vetoed
final class CdiCamelBeanPostProcessor
extends DefaultCamelBeanPostProcessor {
    private final BeanManager manager;
    private final Map<String, CamelPostProcessorHelper> postProcessorHelpers = new HashMap<String, CamelPostProcessorHelper>();

    CdiCamelBeanPostProcessor(BeanManager manager) {
        this.manager = manager;
    }

    protected void injectFields(Object bean, String beanName) {
        ReflectionHelper.doWithFields(bean.getClass(), field -> {
            Produce produce;
            EndpointInject endpointInject;
            BeanInject beanInject;
            PropertyInject propertyInject = field.getAnnotation(PropertyInject.class);
            if (propertyInject != null) {
                try {
                    this.injectFieldProperty(field, propertyInject.value(), propertyInject.defaultValue(), propertyInject.context(), bean, beanName);
                }
                catch (Exception cause) {
                    throw new InjectionException("Injection of [" + propertyInject + "] for field [" + field + "] failed!", (Throwable)cause);
                }
            }
            if ((beanInject = field.getAnnotation(BeanInject.class)) != null && this.getPostProcessorHelper().matchContext(beanInject.context())) {
                try {
                    this.injectFieldBean(field, beanInject.value(), bean, beanName);
                }
                catch (Exception cause) {
                    throw new InjectionException("Injection of [" + beanInject + "] for field [" + field + "] failed!", (Throwable)cause);
                }
            }
            if ((endpointInject = field.getAnnotation(EndpointInject.class)) != null) {
                try {
                    String uri = endpointInject.value().isEmpty() ? endpointInject.uri() : endpointInject.value();
                    this.injectField(field, uri, endpointInject.property(), endpointInject.context(), bean, beanName);
                }
                catch (Exception cause) {
                    throw new InjectionException("Injection of [" + endpointInject + "] for field [" + field + "] failed!", (Throwable)cause);
                }
            }
            if ((produce = field.getAnnotation(Produce.class)) != null) {
                try {
                    String uri = produce.value().isEmpty() ? produce.uri() : produce.value();
                    this.injectField(field, uri, produce.property(), produce.context(), bean, beanName);
                }
                catch (Exception cause) {
                    throw new InjectionException("Injection of [" + produce + "] for field [" + field + "] failed!", (Throwable)cause);
                }
            }
        });
    }

    private void injectField(Field field, String uri, String property, String context, Object bean, String beanName) {
        ReflectionHelper.setField((Field)field, (Object)bean, (Object)this.getPostProcessorHelper(context).getInjectionValue(field.getType(), uri, property, field.getName(), bean, beanName));
    }

    private void injectFieldProperty(Field field, String property, String defaultValue, String context, Object bean, String beanName) {
        ReflectionHelper.setField((Field)field, (Object)bean, (Object)this.getPostProcessorHelper(context).getInjectionPropertyValue(field.getType(), property, defaultValue, field.getName(), bean, beanName));
    }

    private CamelPostProcessorHelper getPostProcessorHelper(String contextName) {
        return this.postProcessorHelpers.computeIfAbsent(contextName, k -> new CamelPostProcessorHelper(this.getOrLookupCamelContext((String)k)));
    }

    private CamelContext getOrLookupCamelContext(String contextName) {
        return BeanManagerHelper.getReferenceByType(this.manager, CamelContext.class, new Annotation[]{contextName.isEmpty() ? DefaultLiteral.DEFAULT : ContextName.Literal.of(contextName)}).orElseThrow(() -> new UnsatisfiedResolutionException("No Camel context with name [" + contextName + "] is deployed!"));
    }

    public CamelContext getOrLookupCamelContext() {
        return BeanManagerHelper.getReferenceByType(this.manager, CamelContext.class, new Annotation[0]).orElse(null);
    }
}

