/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase.converter;

import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.hbase.converter.HBaseModelConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public class HBaseModelConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        this.addTypeConverter(registry, byte[].class, Boolean.class, false, (type, exchange, value) -> HBaseModelConverter.booleanToBytes((Boolean)value));
        this.addTypeConverter(registry, byte[].class, Double.class, false, (type, exchange, value) -> HBaseModelConverter.doubleToBytes((Double)value));
        this.addTypeConverter(registry, byte[].class, Float.class, false, (type, exchange, value) -> HBaseModelConverter.floatToBytes((Float)value));
        this.addTypeConverter(registry, byte[].class, Integer.class, false, (type, exchange, value) -> HBaseModelConverter.integerToBytes((Integer)value));
        this.addTypeConverter(registry, byte[].class, Long.class, false, (type, exchange, value) -> HBaseModelConverter.longToBytes((Long)value));
        this.addTypeConverter(registry, byte[].class, Short.class, false, (type, exchange, value) -> HBaseModelConverter.shortToBytes((Short)value));
        this.addTypeConverter(registry, Boolean.class, byte[].class, false, (type, exchange, value) -> HBaseModelConverter.bytesToBoolean((byte[])value));
        this.addTypeConverter(registry, Double.class, byte[].class, false, (type, exchange, value) -> HBaseModelConverter.bytesToDouble((byte[])value));
        this.addTypeConverter(registry, Float.class, byte[].class, false, (type, exchange, value) -> HBaseModelConverter.bytesToFloat((byte[])value));
        this.addTypeConverter(registry, Integer.class, byte[].class, false, (type, exchange, value) -> HBaseModelConverter.bytesToInteger((byte[])value));
        this.addTypeConverter(registry, Long.class, byte[].class, false, (type, exchange, value) -> HBaseModelConverter.bytesToLong((byte[])value));
        this.addTypeConverter(registry, Short.class, byte[].class, false, (type, exchange, value) -> HBaseModelConverter.bytesToShort((byte[])value));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

