/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.xray;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.entities.TraceID;
import com.amazonaws.xray.exceptions.AlreadyEmittedException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StaticService;
import org.apache.camel.component.aws.xray.NoopTracingStrategy;
import org.apache.camel.component.aws.xray.SegmentDecorator;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XRayTracer
extends ServiceSupport
implements RoutePolicyFactory,
StaticService,
CamelContextAware {
    public static final String XRAY_TRACE_ID = "Camel-AWS-XRay-Trace-ID";
    public static final String XRAY_TRACE_ENTITY = "Camel-AWS-XRay-Trace-Entity";
    private static Map<String, SegmentDecorator> decorators = new HashMap<String, SegmentDecorator>();
    private static final String CURRENT_SEGMENT = "CAMEL_PROPERTY_AWS_XRAY_CURRENT_SEGMENT";
    private final XRayEventNotifier eventNotifier = new XRayEventNotifier();
    private CamelContext camelContext;
    private Set<String> excludePatterns = new HashSet<String>();
    private InterceptStrategy tracingStrategy;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, NamedNode route) {
        this.init(camelContext);
        return new XRayRoutePolicy(routeId);
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        this.camelContext.getManagementStrategy().addEventNotifier((EventNotifier)this.eventNotifier);
        if (!this.camelContext.getRoutePolicyFactories().contains((Object)this)) {
            this.camelContext.addRoutePolicyFactory((RoutePolicyFactory)this);
        }
        if (null == this.tracingStrategy) {
            this.log.info("No tracing strategy available. Defaulting to no-op strategy");
            this.tracingStrategy = new NoopTracingStrategy();
        }
        ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).addInterceptStrategy(this.tracingStrategy);
        this.log.debug("Starting XRay tracer");
    }

    protected void doStop() throws Exception {
        this.camelContext.getManagementStrategy().removeEventNotifier((EventNotifier)this.eventNotifier);
        ServiceHelper.stopAndShutdownService((Object)((Object)this.eventNotifier));
        this.camelContext.getRoutePolicyFactories().remove((Object)this);
        this.log.debug("XRay tracer stopped");
    }

    public void init(CamelContext camelContext) {
        if (!camelContext.hasService((Object)this)) {
            try {
                this.log.debug("Initializing XRay tracer");
                camelContext.addService((Object)this, true, true);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    public InterceptStrategy getTracingStrategy() {
        return this.tracingStrategy;
    }

    public void setTracingStrategy(InterceptStrategy tracingStrategy) {
        this.tracingStrategy = tracingStrategy;
    }

    public Set<String> getExcludePatterns() {
        return this.excludePatterns;
    }

    public void setExcludePatterns(Set<String> excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public void addExcludePattern(String pattern) {
        this.excludePatterns.add(pattern);
    }

    private boolean isExcluded(String routeId) {
        if (!this.excludePatterns.isEmpty()) {
            for (String pattern : this.excludePatterns) {
                if (!pattern.equals(routeId)) continue;
                this.log.debug("Ignoring route with ID {}", (Object)routeId);
                return true;
            }
        }
        return false;
    }

    protected SegmentDecorator getSegmentDecorator(Endpoint endpoint) {
        SegmentDecorator sd = decorators.get(URI.create(endpoint.getEndpointUri()).getScheme());
        if (null == sd) {
            return SegmentDecorator.DEFAULT;
        }
        return sd;
    }

    protected Entity getTraceEntityFromExchange(Exchange exchange) {
        Entity entity = (Entity)exchange.getIn().getHeader(XRAY_TRACE_ENTITY, Entity.class);
        if (entity == null) {
            entity = (Entity)exchange.getProperty(CURRENT_SEGMENT);
        }
        return entity;
    }

    public static String sanitizeName(String name) {
        return name.replaceAll("[^\\w.:/%&#=+\\-@]", "_");
    }

    static {
        ServiceLoader.load(SegmentDecorator.class).forEach(d -> {
            SegmentDecorator existing = decorators.get(d.getComponent());
            if (existing == null || existing.getClass().isInstance(d)) {
                Logger log = LoggerFactory.getLogger(XRayTracer.class);
                log.trace("Adding segment decorator {}", (Object)d.getComponent());
                decorators.put(d.getComponent(), (SegmentDecorator)d);
            }
        });
    }

    private final class XRayRoutePolicy
    extends RoutePolicySupport {
        private String routeId;

        XRayRoutePolicy(String routeId) {
            this.routeId = routeId;
        }

        public void onExchangeBegin(Route route, Exchange exchange) {
            TraceID traceID;
            boolean createSegment;
            if (XRayTracer.this.isExcluded(route.getId())) {
                return;
            }
            this.log.trace("=> RoutePolicy-Begin: Route: {} - RouteId: {}", (Object)this.routeId, (Object)route.getId());
            Entity entity = XRayTracer.this.getTraceEntityFromExchange(exchange);
            boolean bl = createSegment = entity == null || !Objects.equals(entity.getName(), this.routeId);
            if (exchange.getIn().getHeaders().containsKey(XRayTracer.XRAY_TRACE_ID)) {
                traceID = TraceID.fromString((String)((String)exchange.getIn().getHeader(XRayTracer.XRAY_TRACE_ID, String.class)));
            } else {
                traceID = new TraceID();
                exchange.getIn().setHeader(XRayTracer.XRAY_TRACE_ID, (Object)traceID.toString());
            }
            AWSXRay.setTraceEntity((Entity)entity);
            SegmentDecorator sd = XRayTracer.this.getSegmentDecorator(route.getEndpoint());
            if (createSegment) {
                Segment segment = AWSXRay.beginSegment((String)XRayTracer.sanitizeName(route.getId()));
                segment.setParent(entity);
                segment.setTraceId(traceID);
                sd.pre((Entity)segment, exchange, route.getEndpoint());
                this.log.trace("Created new XRay segment {} with name {}", (Object)segment.getId(), (Object)segment.getName());
                exchange.setProperty(XRayTracer.CURRENT_SEGMENT, (Object)segment);
            } else {
                String segmentName = entity.getId();
                try {
                    Subsegment subsegment = AWSXRay.beginSubsegment((String)route.getId());
                    sd.pre((Entity)subsegment, exchange, route.getEndpoint());
                    this.log.trace("Creating new subsegment with ID {} and name {} (parent {}, references: {})", new Object[]{subsegment.getId(), subsegment.getName(), subsegment.getParentSegment().getId(), subsegment.getParentSegment().getReferenceCount()});
                    exchange.setProperty(XRayTracer.CURRENT_SEGMENT, (Object)subsegment);
                }
                catch (AlreadyEmittedException aeEx) {
                    this.log.warn("Ignoring opening of subsegment " + route.getId() + " as its parent segment " + segmentName + " was already emitted before.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onExchangeDone(Route route, Exchange exchange) {
            if (XRayTracer.this.isExcluded(route.getId())) {
                return;
            }
            this.log.trace("=> RoutePolicy-Done: Route: {} - RouteId: {}", (Object)this.routeId, (Object)route.getId());
            Entity entity = XRayTracer.this.getTraceEntityFromExchange(exchange);
            AWSXRay.setTraceEntity((Entity)entity);
            try {
                SegmentDecorator sd = XRayTracer.this.getSegmentDecorator(route.getEndpoint());
                sd.post(entity, exchange, route.getEndpoint());
                entity.close();
                this.log.trace("Closing down (sub)segment {} with name {} (parent {}, references: {})", new Object[]{entity.getId(), entity.getName(), entity.getParentSegment().getId(), entity.getParentSegment().getReferenceCount()});
                exchange.setProperty(XRayTracer.CURRENT_SEGMENT, (Object)entity.getParent());
            }
            catch (AlreadyEmittedException aeEx) {
                this.log.warn("Ignoring closing of (sub)segment {} as the segment was already emitted.", (Object)route.getId());
            }
            catch (Exception e) {
                this.log.warn("Error closing entity");
            }
            finally {
                AWSXRay.setTraceEntity(null);
            }
        }

        public String toString() {
            return "XRayRoutePolicy";
        }
    }

    private final class XRayEventNotifier
    extends EventNotifierSupport {
        private XRayEventNotifier() {
        }

        public void notify(CamelEvent event) throws Exception {
            if (event instanceof CamelEvent.ExchangeSendingEvent) {
                CamelEvent.ExchangeSendingEvent ese = (CamelEvent.ExchangeSendingEvent)event;
                this.log.trace("-> {} - target: {} (routeId: {})", new Object[]{event.getClass().getSimpleName(), ese.getEndpoint(), ese.getExchange().getFromRouteId()});
                SegmentDecorator sd = XRayTracer.this.getSegmentDecorator(ese.getEndpoint());
                if (!sd.newSegment()) {
                    return;
                }
                Entity entity = XRayTracer.this.getTraceEntityFromExchange(ese.getExchange());
                if (entity != null) {
                    AWSXRay.setTraceEntity((Entity)entity);
                    String name = sd.getOperationName(ese.getExchange(), ese.getEndpoint());
                    if (sd.getComponent() != null) {
                        name = sd.getComponent() + ":" + name;
                    }
                    name = XRayTracer.sanitizeName(name);
                    try {
                        Subsegment subsegment = AWSXRay.beginSubsegment((String)name);
                        sd.pre((Entity)subsegment, ese.getExchange(), ese.getEndpoint());
                        this.log.trace("Creating new subsegment with ID {} and name {} (parent {}, references: {})", new Object[]{subsegment.getId(), subsegment.getName(), subsegment.getParentSegment().getId(), subsegment.getParentSegment().getReferenceCount()});
                        ese.getExchange().setProperty(XRayTracer.CURRENT_SEGMENT, (Object)subsegment);
                    }
                    catch (AlreadyEmittedException aeEx) {
                        this.log.warn("Ignoring starting of subsegment " + name + " as its parent segment was already emitted to AWS.");
                    }
                } else {
                    this.log.trace("Ignoring creation of XRay subsegment as no segment exists in the current thread");
                }
            } else if (event instanceof CamelEvent.ExchangeSentEvent) {
                CamelEvent.ExchangeSentEvent ese = (CamelEvent.ExchangeSentEvent)event;
                this.log.trace("-> {} - target: {} (routeId: {})", new Object[]{event.getClass().getSimpleName(), ese.getEndpoint(), ese.getExchange().getFromRouteId()});
                Entity entity = XRayTracer.this.getTraceEntityFromExchange(ese.getExchange());
                if (entity instanceof Subsegment) {
                    AWSXRay.setTraceEntity((Entity)entity);
                    SegmentDecorator sd = XRayTracer.this.getSegmentDecorator(ese.getEndpoint());
                    try {
                        Subsegment subsegment = (Subsegment)entity;
                        sd.post((Entity)subsegment, ese.getExchange(), ese.getEndpoint());
                        subsegment.close();
                        this.log.trace("Closing down subsegment with ID {} and name {}", (Object)subsegment.getId(), (Object)subsegment.getName());
                        this.log.trace("Setting trace entity for exchange {} to {}", (Object)ese.getExchange(), (Object)subsegment.getParent());
                        ese.getExchange().setProperty(XRayTracer.CURRENT_SEGMENT, (Object)subsegment.getParent());
                    }
                    catch (AlreadyEmittedException aeEx) {
                        this.log.warn("Ignoring close of subsegment " + entity.getName() + " as its parent segment was already emitted to AWS");
                    }
                }
            } else {
                this.log.trace("Received event {} from source {}", (Object)event, event.getSource());
            }
        }

        public boolean isEnabled(CamelEvent event) {
            return event instanceof CamelEvent.ExchangeSendingEvent || event instanceof CamelEvent.ExchangeSentEvent;
        }

        public String toString() {
            return "XRayEventNotifier";
        }
    }
}

