/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache.springboot.customizer;

import org.apache.camel.component.ehcache.EhcacheComponent;
import org.apache.camel.component.ehcache.springboot.EhcacheComponentAutoConfiguration;
import org.apache.camel.component.ehcache.springboot.customizer.CacheManagerCustomizerConfiguration;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spi.HasId;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.ehcache.CacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.Order;

@Order(value=0x7FFFFFFF)
@Configuration
@Conditional(value={NestedConditions.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@AutoConfigureBefore(value={EhcacheComponentAutoConfiguration.class})
@EnableConfigurationProperties(value={CacheManagerCustomizerConfiguration.class})
public class CacheManagerCustomizer
implements HasId,
ComponentCustomizer<EhcacheComponent> {
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private CacheManagerCustomizerConfiguration configuration;

    public void customize(EhcacheComponent component) {
        if (this.configuration.isOverride() || component.getCacheManager() == null) {
            component.setCacheManager(this.cacheManager);
        }
    }

    public String getId() {
        return "camel.component.ehcache.customizer.cache-manager";
    }

    static class NestedConditions
    extends AllNestedConditions {
        public NestedConditions() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={CamelAutoConfiguration.class})
        static class OnCamelAutoConfiguration {
            OnCamelAutoConfiguration() {
            }
        }

        @ConditionalOnBean(value={CacheManager.class})
        static class OnCacheManager {
            OnCacheManager() {
            }
        }
    }
}

