/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import java.io.BufferedReader;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.http.common.HttpConverter;
import org.apache.camel.http.common.HttpMessage;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public class HttpConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        this.addTypeConverter(registry, BufferedReader.class, HttpMessage.class, false, (type, exchange, value) -> HttpConverter.toReader((HttpMessage)((Object)((Object)value))));
        this.addTypeConverter(registry, InputStream.class, HttpServletRequest.class, false, (type, exchange, value) -> HttpConverter.toInputStream((HttpServletRequest)value, exchange));
        this.addTypeConverter(registry, InputStream.class, HttpMessage.class, false, (type, exchange, value) -> HttpConverter.toInputStream((HttpMessage)((Object)((Object)value)), exchange));
        this.addTypeConverter(registry, ServletInputStream.class, HttpMessage.class, false, (type, exchange, value) -> HttpConverter.toServletInputStream((HttpMessage)((Object)((Object)value))));
        this.addTypeConverter(registry, HttpServletRequest.class, Message.class, false, (type, exchange, value) -> HttpConverter.toServletRequest((Message)value));
        this.addTypeConverter(registry, HttpServletResponse.class, Message.class, false, (type, exchange, value) -> HttpConverter.toServletResponse((Message)value));
    }

    private void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

