/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxEvent;
import com.box.sdk.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.box.BoxConfiguration;
import org.apache.camel.component.box.BoxEndpoint;
import org.apache.camel.component.box.api.BoxEventsManager;
import org.apache.camel.component.box.internal.BoxApiName;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.component.AbstractApiConsumer;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiConsumerHelper;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodHelper;
import org.apache.camel.support.component.PropertyNamesInterceptor;

public class BoxConsumer
extends AbstractApiConsumer<BoxApiName, BoxConfiguration>
implements EventListener {
    private static final String LISTENER_PROPERTY = "listener";
    private BoxAPIConnection boxConnection;
    private BoxEventsManager apiProxy;
    private final ApiMethod apiMethod;
    private final Map<String, Object> properties;

    public BoxConsumer(BoxEndpoint endpoint, Processor processor) {
        super((AbstractApiEndpoint)endpoint, processor);
        this.apiMethod = ApiConsumerHelper.findMethod((AbstractApiEndpoint)endpoint, (PropertyNamesInterceptor)this);
        this.properties = new HashMap<String, Object>();
        this.properties.putAll(endpoint.getEndpointProperties());
        this.properties.put(LISTENER_PROPERTY, (Object)this);
        this.boxConnection = endpoint.getBoxConnection();
        this.apiProxy = new BoxEventsManager(this.boxConnection);
    }

    public void interceptPropertyNames(Set<String> propertyNames) {
        propertyNames.add(LISTENER_PROPERTY);
    }

    public void onEvent(BoxEvent event) {
        try {
            this.log.debug("Processed {} event for {}", (Object)ApiConsumerHelper.getResultsProcessed((DefaultConsumer)this, (Object)event, (boolean)false), (Object)this.boxConnection);
        }
        catch (Exception e) {
            this.log.info("Received exception consuming event: ", (Throwable)e);
        }
    }

    public void onNextPosition(long position) {
    }

    public boolean onException(Throwable e) {
        this.getExceptionHandler().handleException((Throwable)RuntimeCamelException.wrapRuntimeCamelException((Throwable)e));
        return true;
    }

    protected void doStart() throws Exception {
        super.doStart();
        ApiMethodHelper.invokeMethod((Object)this.apiProxy, (ApiMethod)this.apiMethod, this.properties);
    }

    protected void doStop() throws Exception {
        this.apiProxy.stopListening();
        super.doStop();
    }
}

