/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.azure.queue.springboot;

import javax.annotation.Generated;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.queue.CloudQueue;
import org.apache.camel.component.azure.queue.QueueServiceOperations;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * The azure-queue component is used for storing and retrieving messages from
 * Azure Storage Queue Service.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.azure-queue")
public class QueueServiceComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the azure-queue component. This
     * is enabled by default.
     */
    private Boolean enabled;
    /**
     * The Queue Service configuration
     */
    private QueueServiceConfigurationNestedConfiguration configuration;
    /**
     * Whether the component should resolve property placeholders on itself when
     * starting. Only properties which are of String type can use property
     * placeholders.
     */
    private Boolean resolvePropertyPlaceholders = true;
    /**
     * Whether the component should use basic property binding (Camel 2.x) or
     * the newer property binding with additional capabilities
     */
    private Boolean basicPropertyBinding = false;

    public QueueServiceConfigurationNestedConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(
            QueueServiceConfigurationNestedConfiguration configuration) {
        this.configuration = configuration;
    }

    public Boolean getResolvePropertyPlaceholders() {
        return resolvePropertyPlaceholders;
    }

    public void setResolvePropertyPlaceholders(
            Boolean resolvePropertyPlaceholders) {
        this.resolvePropertyPlaceholders = resolvePropertyPlaceholders;
    }

    public Boolean getBasicPropertyBinding() {
        return basicPropertyBinding;
    }

    public void setBasicPropertyBinding(Boolean basicPropertyBinding) {
        this.basicPropertyBinding = basicPropertyBinding;
    }

    public static class QueueServiceConfigurationNestedConfiguration {
        public static final Class CAMEL_NESTED_CLASS = org.apache.camel.component.azure.queue.QueueServiceConfiguration.class;
        /**
         * The queue resource name
         */
        private String queueName;
        /**
         * The queue service client
         */
        private CloudQueue azureQueueClient;
        /**
         * Queue service operation hint to the producer
         */
        private QueueServiceOperations operation = QueueServiceOperations.listQueues;
        /**
         * Message Time To Live in seconds
         */
        private Integer messageTimeToLive;
        /**
         * Message Visibility Delay in seconds
         */
        private Integer messageVisibilityDelay;
        /**
         * Set a prefix which can be used for listing the queues
         */
        private String queuePrefix;
        /**
         * Set the Azure account name
         */
        private String accountName;
        /**
         * Set the storage credentials, required in most cases
         */
        private StorageCredentials credentials;

        public String getQueueName() {
            return queueName;
        }

        public void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        public CloudQueue getAzureQueueClient() {
            return azureQueueClient;
        }

        public void setAzureQueueClient(CloudQueue azureQueueClient) {
            this.azureQueueClient = azureQueueClient;
        }

        public QueueServiceOperations getOperation() {
            return operation;
        }

        public void setOperation(QueueServiceOperations operation) {
            this.operation = operation;
        }

        public Integer getMessageTimeToLive() {
            return messageTimeToLive;
        }

        public void setMessageTimeToLive(Integer messageTimeToLive) {
            this.messageTimeToLive = messageTimeToLive;
        }

        public Integer getMessageVisibilityDelay() {
            return messageVisibilityDelay;
        }

        public void setMessageVisibilityDelay(Integer messageVisibilityDelay) {
            this.messageVisibilityDelay = messageVisibilityDelay;
        }

        public String getQueuePrefix() {
            return queuePrefix;
        }

        public void setQueuePrefix(String queuePrefix) {
            this.queuePrefix = queuePrefix;
        }

        public String getAccountName() {
            return accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public StorageCredentials getCredentials() {
            return credentials;
        }

        public void setCredentials(StorageCredentials credentials) {
            this.credentials = credentials;
        }
    }
}